-- phpMyAdmin SQL Dump
-- version 4.1.14
-- http://www.phpmyadmin.net
--
-- Host: 127.0.0.1
-- Generation Time: Sep 17, 2015 at 04:40 AM
-- Server version: 5.6.17
-- PHP Version: 5.5.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

--
-- Database: `ardibase`
--
CREATE DATABASE ardi;
USE ardi;

-- --------------------------------------------------------

--
-- Table structure for table `alerts`
--

CREATE TABLE IF NOT EXISTS `alerts` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assetid` bigint(20) NOT NULL,
  `name` varchar(60) NOT NULL,
  `relationship` bigint(20) NOT NULL,
  `description` varchar(128) NOT NULL,
  `media` bigint(20) NOT NULL,
  `state` int(11) NOT NULL DEFAULT '0',
  `function` varchar(120) NOT NULL DEFAULT '',
  `basedon` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `assetid` (`assetid`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ardilog`
--

CREATE TABLE IF NOT EXISTS `ardilog` (
  `stamp` datetime NOT NULL,
  `area` int(11) NOT NULL DEFAULT '0',
  `id` bigint(20) NOT NULL,
  `content` varchar(128) NOT NULL,
  `userid` bigint(20) NOT NULL,
  KEY `area` (`area`,`id`,`stamp`),
  KEY `stamp` (`stamp`),
  KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `artags`
--

CREATE TABLE IF NOT EXISTS `artags` (
  `id` int(11) NOT NULL,
  `area` varchar(40) NOT NULL,
  `location` varchar(64) NOT NULL,
  PRIMARY KEY (`id`,`area`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `assetreferences`
--

CREATE TABLE IF NOT EXISTS `assetreferences` (
  `parentasset` bigint(20) NOT NULL,
  `childasset` bigint(20) NOT NULL,
  `childproperty` bigint(20) NOT NULL,
  `name` VARCHAR(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`parentasset`,`childasset`,`childproperty`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

--
-- Table structure for table `assetrelationships`
--

CREATE TABLE IF NOT EXISTS `assetrelationships` (
  `parentasset` bigint(20) NOT NULL,
  `childasset` bigint(20) NOT NULL,
  `relationship` bigint(20) NOT NULL,
  PRIMARY KEY (`parentasset`,`childasset`,`relationship`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `assetrelationships`
--

INSERT IGNORE INTO `assetrelationships` (`parentasset`, `childasset`, `relationship`) VALUES
(1, 5, 2),
(2, 5, 1);

-- --------------------------------------------------------

--
-- Table structure for table `assetrelclosures`
--

CREATE TABLE IF NOT EXISTS `assetrelclosures` (
  `parentasset` bigint(20) NOT NULL,
  `childasset` bigint(20) NOT NULL,
  `depth` int(11) NOT NULL,
  `relationship` bigint(20) NOT NULL,
  PRIMARY KEY (`parentasset`,`childasset`,`depth`,`relationship`),
  KEY `childasset` (`childasset`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `assetrelclosures`
--

INSERT IGNORE INTO `assetrelclosures` (`parentasset`, `childasset`, `depth`, `relationship`) VALUES
(1, 5, 0, 2),
(2, 5, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `assets`
--

CREATE TABLE IF NOT EXISTS `assets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(120) NOT NULL,
  `descript` text NOT NULL,
  `type` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `assets`
--

INSERT IGNORE INTO `assets` (`id`, `name`, `descript`, `type`) VALUES
(1, 'Location', 'The basepoint of your Location heirachy', 2),
(3, 'Types', 'The basepoint of the Tagging hierarchy', 2),
(5, 'Site', 'This is your initial ARDI site', 0);

-- --------------------------------------------------------

--
-- Table structure for table `assetvalues`
--

CREATE TABLE IF NOT EXISTS `assetvalues` (
  `assetid` int(11) NOT NULL,
  `propertyid` int(11) NOT NULL,
  `value` varchar(120) NOT NULL,
  PRIMARY KEY (`assetid`,`propertyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `assetvalues`
--

INSERT IGNORE INTO `assetvalues` (`assetid`, `propertyid`, `value`) VALUES
(5, 3, '10/75 Cygnet Avenue, Shellharbour City Center, NSW, Australia');

-- --------------------------------------------------------

--
-- Table structure for table `connections`
--

CREATE TABLE IF NOT EXISTS `connections` (
  `fromasset` bigint(20) NOT NULL,
  `toasset` bigint(20) NOT NULL,
  `startpoint` varchar(32) NOT NULL,
  `endpoint` varchar(32) NOT NULL,
  `points` varchar(255) NOT NULL,
  `style` int(11) NOT NULL,
  `options` varchar(80) NOT NULL,
  PRIMARY KEY (`fromasset`,`toasset`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `datadriver`
--

CREATE TABLE IF NOT EXISTS `datadriver` (
  `port` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `driver` varchar(60) NOT NULL,
  `address` varchar(80) NOT NULL,
  `mode` smallint(6) NOT NULL,
  PRIMARY KEY (`port`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=9559 ;


-- --------------------------------------------------------

--
-- Table structure for table `datalinks`
--

CREATE TABLE IF NOT EXISTS `datalinks` (
  `sourceid` bigint(20) NOT NULL,
  `assetid` bigint(20) NOT NULL,
  `propertyid` bigint(20) NOT NULL,
  `node` varchar(40) NOT NULL,
  `profile` int(11) NOT NULL,
  `mode` smallint(6) NOT NULL,
  `address` varchar(255) NOT NULL,
  `transform` varchar(255) NOT NULL,
  `lastupdate` datetime NOT NULL,
  `frequency` int(11) NOT NULL,
  `lastvalue` varchar(60) NOT NULL,
  `updaterequired` int(11) NOT NULL,
  PRIMARY KEY (`assetid`,`sourceid`,`propertyid`,`node`,`profile`,`mode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

--
-- Table structure for table `datasources`
--

CREATE TABLE IF NOT EXISTS `datasources` (
  `assetid` bigint(20) NOT NULL,
  `driver` varchar(60) NOT NULL,
  `address` varchar(120) NOT NULL,
  `lastwd` datetime NOT NULL,
  `gatewayport` int(11) NOT NULL,
  `mode` int(11) NOT NULL DEFAULT '0',
  `profile` int(11) NOT NULL DEFAULT '1',
  `samplerate` int(11) NOT NULL DEFAULT '30',
  PRIMARY KEY (`assetid`,`profile`,`mode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

--
-- Table structure for table `links`
--

CREATE TABLE IF NOT EXISTS `links` (
  `relationshipid` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `anchor` varchar(32) NOT NULL,
  `pos` varchar(32) NOT NULL,
  `nextid` bigint(20) NOT NULL,
  `previd` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mediafiles`
--

CREATE TABLE IF NOT EXISTS `mediafiles` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `category` varchar(60) NOT NULL,
  `path` varchar(120) NOT NULL,
  `mediatype` varchar(25) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mediatags`
--

CREATE TABLE IF NOT EXISTS `mediatags` (
  `mediaid` bigint(20) NOT NULL,
  `assetid` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `models`
--

CREATE TABLE IF NOT EXISTS `models` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `category` varchar(60) NOT NULL,
  `type` varchar(80) NOT NULL,
  `style` varchar(80) NOT NULL,
  `model` varchar(80) NOT NULL,
  `obj` varchar(80) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Uniquness` (`type`,`style`,`model`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=29 ;

--
-- Dumping data for table `models`
--
-- --------------------------------------------------------

--
-- Table structure for table `modelskins`
--

CREATE TABLE IF NOT EXISTS `modelskins` (
  `modelid` bigint(20) NOT NULL,
  `name` varchar(48) NOT NULL,
  `skinid` bigint(20) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`skinid`),
  UNIQUE KEY `modelid` (`modelid`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=20 ;

--
-- Dumping data for table `modelskins`
--

INSERT IGNORE INTO `modelskins` (`modelid`, `name`, `skinid`) VALUES
(0, 'Painted - Gloss', 4),
(0, 'Painted - Matt', 2),
(0, 'Painted - Semi-Gloss', 3),
(0, 'Stainless - Bright', 6),
(0, 'Stainless - Rough', 5);

-- --------------------------------------------------------

--
-- Table structure for table `profiles`
--

CREATE TABLE IF NOT EXISTS `profiles` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `reqport` int(11) NOT NULL,
  `subport` int(11) NOT NULL,
  `address` varchar(120) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `profiles`
--

INSERT IGNORE INTO `profiles` (`id`, `name`, `reqport`, `subport`, `address`) VALUES
(1, 'Actual', 8079, 5225, 'localhost');

-- --------------------------------------------------------

--
-- Table structure for table `properties`
--

CREATE TABLE IF NOT EXISTS `properties` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `typename` varchar(40) NOT NULL,
  `options` varchar(128) NOT NULL,
  `builtin` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=16 ;

--
-- Dumping data for table `properties`
--

INSERT IGNORE INTO `properties` (`id`, `name`, `typename`, `options`, `builtin`) VALUES
(2, 'Equipment Tag', 'TAG', '', 1),
(3, 'Address', 'ADDRESS', '', 1),
(4, 'Area of Effect','AOE','',1),
(9, 'Layout', 'LAYOUT', '', 1),
(12, 'AR Marker', 'ARTAG', '', 1),
(13, 'Placement', 'LOCATION', '', 1),
(14, 'Appearance', 'MODEL', '', 1),
(15, 'Isolation Point', 'ISOPOINT', '', 1),
(16, 'Source Point', 'SRCPOINT', '', 1),
(17, 'Non-Return Point', 'NRPOINT', '', 1),
(18, 'Symbol', 'SYMBOL', '', 1),
(19, 'Template Name','TEMPLATE','hide=dash&AR&VE',1),
(10, 'AR Marker Distance','ARDISTANCE','',1),
(5, 'Signs','WARNINGS','',1);

-- --------------------------------------------------------

--
-- Table structure for table `relationships`
--

CREATE TABLE IF NOT EXISTS `relationships` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `upstreamname` varchar(80) NOT NULL,
  `downstreamname` varchar(80) NOT NULL,
  `flags` int(11) NOT NULL DEFAULT '0',
  `rootasset` bigint(20) NOT NULL,
  `options` varchar(80) NOT NULL,
  `colour` varchar(8) NOT NULL,
  `style` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=11;

--
-- Dumping data for table `relationships`
--

INSERT IGNORE INTO `relationships` (`id`, `name`, `upstreamname`, `downstreamname`, `flags`, `rootasset`, `options`, `colour`, `style`) VALUES
(2, 'Location', 'Inside', 'Contains', 2, 1, '', '', 3),
(3, 'Type', 'A Type Of', 'Is Assigned To', 2, 3, '', '', 2),
(4, 'Data', 'Taken From', 'Fed To', 0, 0, '', '', 1),
(5, 'Control', 'Controled By', 'Controls', 0, 0, '', '#ffffff', 1),
(6, 'Monitors', 'Monitored By', 'Monitors', 2, 0, '', '#22FF22', 0),
(7, 'Integrated','Integrated Into','Is Integrated With',2,0,'integrated','#EEEEEE',0);

-- --------------------------------------------------------

--
-- Table structure for table `timeline`
--

CREATE TABLE IF NOT EXISTS `timeline` (
  `assetid` bigint(20) NOT NULL,
  `stamp` datetime NOT NULL,
  `source` int(11) NOT NULL,
  `message` varchar(128) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `userapi`
--

CREATE TABLE IF NOT EXISTS `userapi` (
  `userid` bigint(20) NOT NULL,
  `apicode` varchar(120) NOT NULL,
  `lastaccessed` datetime NOT NULL,
  UNIQUE KEY `apicode` (`apicode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `userdata`
--

CREATE TABLE IF NOT EXISTS `userdata` (
  `userid` bigint(20) NOT NULL,
  `property` varchar(32) NOT NULL,
  `value` varchar(128) NOT NULL,
  UNIQUE KEY `userid` (`userid`,`property`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `userid` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(80) NOT NULL,
  `token` varchar(120) NOT NULL,
  `email` varchar(80) NOT NULL,
  `source` varchar(60) NOT NULL,
  `pwd` varchar(64) NOT NULL,
  `basegroup` varchar(32) NOT NULL,
  PRIMARY KEY (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `users`
--

INSERT IGNORE INTO `users` (`userid`, `username`, `token`, `email`, `source`, `pwd`, `basegroup`) VALUES
(1, 'admin', '1', 'haha@fooledyou.com', 'local', '*69156C3775BC63A03BDF56AD0B48E2BE5DF601DD', 'Superuser');

--
-- Creating Units of Measure Table
--

CREATE TABLE IF NOT EXISTS `uom` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(12) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `category` varchar(40) NOT NULL,
  `value` float NOT NULL,
  `offset` float NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `category` (`category`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=41 ;

--
-- Dumping data for table `uom`
--

INSERT IGNORE INTO `uom` (`id`, `name`, `category`, `value`, `offset`) VALUES
(1, ' Deg', 'Angle', 1, 0),
(2, ' Deg C', 'Temperature', 1, 0),
(3, ' Deg F', 'Temperature', 1, 32),
(4, ' Deg K', 'Temperature', 1, -272.15),
(5, ' Hz', 'Frequency', 1, 0),
(6, ' KHz', 'Frequency', 1000, 0),
(7, ' MHz', 'Frequency', 1000000, 0),
(8, ' mi', 'Distance', 1609.34, 0),
(9, ' Radians', 'Angle', 0.0174533, 0),
(10, '%', 'General', 1, 0),
(11, 'cm', 'Distance', 0.001, 0),
(12, 'ft', 'Distance', 3.28084, 0),
(13, 'in', 'Distance', 39.3701, 0),
(14, 'km', 'Distance', 1000, 0),
(15, 'm', 'Distance', 1, 0),
(16, 'mm', 'Distance', 0.0001, 0),
(17, 'Pa', 'Pressure', 1, 0),
(18, 'kPa', 'Pressure', 1000, 0),
(19, 'MPa', 'Pressure', 1000000, 0),
(20, ' BAR', 'Pressure', 10000, 0),
(21, ' PSI', 'Pressure', 0.000145038, 0),
(22, ' in wg', 'Pressure', 0.00401474, 0),
(23, ' lx', 'Brightness', 1, 0),
(24, ' J', 'Energy', 1, 0),
(25, 'W', 'Power', 1, 0),
(26, ' N', 'Force', 1, 0),
(27, ' V', 'Voltage', 1, 0),
(28, ' Ohm', 'Resistance', 1, 0),
(29, ' MV', 'Voltage', 1000000, 0),
(30, ' mV', 'Voltage', 0.0001, 0),
(31, ' kJ', 'Energy', 1000, 0),
(32, ' MJ', 'Energy', 1000000, 0),
(33, ' kW', 'Power', 1000, 0),
(34, ' MW', 'Power', 1000000, 0),
(35, 'mmWG', 'Pressure', 9.80665, 0),
(36, ' kN', 'Force', 1000, 0),
(37, ' MN', 'Force', 1000000, 0),
(38, ' A', 'Current', 1, 0),
(39, ' mA', 'Current', 0.0001, 0),
(40, ' MA', 'Current', 1000000, 0);

CREATE TABLE IF NOT EXISTS `symbols` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `category` varchar(60) NOT NULL,
  `type` varchar(80) NOT NULL,
  `name` varchar(80) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Uniquness` (`category`,`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `userpersist` (
  `userid` bigint(20) NOT NULL,
  `type` int(11) NOT NULL,
  `contextid` bigint(20) DEFAULT NULL,
  `value` varchar(255) NOT NULL,
  `stamp` datetime NOT NULL,
  KEY `userid` (`userid`,`type`,`contextid`,`stamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `details` (
  `version` varchar(40) NOT NULL,
  `sitename` varchar(80) NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT IGNORE INTO `details` (`version`, `sitename`, `created`) VALUES
('0.9.9e', 'ARDI', CURRENT_TIMESTAMP);

CREATE TABLE IF NOT EXISTS `addons` (
  `code` varchar(60) NOT NULL,
  `version` varchar(32) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS assetoptionparameters (
  assetid bigint(20) NOT NULL,
  sequenceno int(11) NOT NULL,
  attribute varchar(64) NOT NULL,
  internal BOOLEAN NOT NULL DEFAULT TRUE,
  `value` varchar(128) NOT NULL,
  PRIMARY KEY (assetid,sequenceno,attribute)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS assetoptions (
  assetid bigint(20) NOT NULL,
  sequenceno int(11) NOT NULL,
  effect varchar(64) NOT NULL,
  internal tinyint(1) NOT NULL,
  PRIMARY KEY (assetid,sequenceno)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS propertygroups (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

INSERT IGNORE INTO `propertygroups` (`id`, `name`) VALUES
(1, 'Additional Info');