import pycurl
import urllib
import xmltodict
try:
    from io import BytesIO
except ImportError:
    from StringIO import StringIO as BytesIO

class ARDIAsset:
    def __init__(self, core, id):
        self.core = core
        self.id = id

    def GetData()
        pass

class ARDIAssets:
    def __init__(self, core):
        self.core = core

    def SetInput(self,asset,property,input,value):

        final = urllib.urlencode({ 'asset' : asset, 'property': property, 'input' : input, 'value' : value })

        resp = []

        buffer = BytesIO()
        ar = pycurl.Curl()
        ar.setopt(ar.URL, 'http://' + self.core.server + ':' + str(self.core.port) + '/api/setdata.php?' + final)
        ar.setopt(ar.WRITEFUNCTION, buffer.write)
        ar.perform()
        
        # HTTP response code, e.g. 200.
        if ar.getinfo(ar.RESPONSE_CODE) == 200:    
            xml = xmltodict.parse(buffer.getvalue())

            ar.close()

            #print xml;
            try:
                res = xml['response']['success']
                return True
            except:
                return False            
            
        ar.close()
        return False

    def SetData(self,asset,property,value):

        final = urllib.urlencode({ 'asset' : asset, 'property': property, 'value' : value })

        resp = []

        buffer = BytesIO()
        ar = pycurl.Curl()
        ar.setopt(ar.URL, 'http://' + self.core.server + ':' + str(self.core.port) + '/api/setdata.php?' + final)
        ar.setopt(ar.WRITEFUNCTION, buffer.write)
        ar.perform()
        
        # HTTP response code, e.g. 200.
        if ar.getinfo(ar.RESPONSE_CODE) == 200:    
            xml = xmltodict.parse(buffer.getvalue())

            ar.close()

            #print xml;
            try:
                res = xml['response']['success']
                return True
            except:
                return False            
            
        ar.close()
        return False

    def LinkData(self,asset,property,value,source,address):

        final = urllib.urlencode({ 'asset' : asset, 'property': property, 'value' : value })

        resp = []

        buffer = BytesIO()
        ar = pycurl.Curl()
        ar.setopt(ar.URL, 'http://' + self.core.server + ':' + str(self.core.port) + '/api/setdata.php?' + final)
        ar.setopt(ar.WRITEFUNCTION, buffer.write)
        ar.perform()
        
        # HTTP response code, e.g. 200.
        if ar.getinfo(ar.RESPONSE_CODE) == 200:    
            xml = xmltodict.parse(buffer.getvalue())

            ar.close()

            #print xml;
            try:
                res = xml['response']['success']
                return True
            except:
                return False            
            
        ar.close()
        return False