import pycurl
import urllib
import xmltodict
try:
    from io import BytesIO
except ImportError:
    from StringIO import StringIO as BytesIO

class ARDIContext:
    def __init__(self):
        self.consolidator = 5336
        self.submission = 2991
        self.name = "Actual"
        self.server = ""

class ARDICore:
    def __init__(self, srv):
        self.server = srv
        #self.port = prt
        #self.consolidatorhost = srv
        #self.consolidatorport = 5336
        self.webport = 80
        self.contexts = []

    def Connect(self):
        buffer = BytesIO()
        ar = pycurl.Curl()
        ar.setopt(ar.URL, 'http://' + self.server + '/api/connect')
        ar.setopt(ar.WRITEFUNCTION, buffer.write)
        ar.perform()

        #print 'http://' + self.server + '/api/connect'

        # HTTP response code, e.g. 200.
        if ar.getinfo(ar.RESPONSE_CODE) == 200:
            ar.close()

            #print 'XML Content: ' + buffer.getvalue()
            xml = xmltodict.parse(buffer.getvalue())
            
            for d in xml['ardi']['service']:
                #print 'Checking ' + d['@name']
                if d['@name'] == 'data':
                    prt = 5336
                    src = self.server
                    try:
                        prt = d['@port']
                    except:
                        pass
                    
                    try:
                        src = d['@host']
                    except:
                        pass                

                    ctx = ARDIContext()
                    ctx.consolidator= prt
                    ctx.server = src
                    ctx.name = "Actual"
                    self.contexts.append(ctx)
            return True
        else:
            ar.close()
            return False        
        

    def GetConfiguration(self):
        buffer = BytesIO()
        ar = pycurl.Curl()
        ar.setopt(ar.URL, 'http://' + self.server + ':' + str(self.port) + '/api/getconfiguration.php')
        ar.setopt(ar.WRITEFUNCTION, buffer.write)
        ar.perform()        

        # HTTP response code, e.g. 200.
        if ar.getinfo(ar.RESPONSE_CODE) == 200:
            #print buffer.getvalue()
            xml = xmltodict.parse(buffer.getvalue())

            rels = []
            props = []

            for ele in xml['config']['relations']['relationship']:
                rels.append({ 'name': ele['@name'], 'id': ele['@id'] })                
            
            for ele in xml['config']['properties']['property']:
                props.append({ 'name' : ele['@name'], 'type' : ele['@type'], 'id' : ele['@id'] })
        else:
            return None
                
        ar.close()        
        return [rels,props]

    def GetDataSourceInfo(self):
        buffer = BytesIO()
        ar = pycurl.Curl()
        ar.setopt(ar.URL, 'http://' + self.server + ':' + str(self.port) + '/api/getdatasources.php')
        ar.setopt(ar.WRITEFUNCTION, buffer.write)
        ar.perform()        

        # HTTP response code, e.g. 200.
        if ar.getinfo(ar.RESPONSE_CODE) == 200:            
            xml = xmltodict.parse(buffer.getvalue())

            drivers = []
            dsources = []

            for ele in xml['config']['drivers']['driver']:
                drivers.append({ 'name': ele['@name'], 'port': ele['@port'], 'code' : ele['@code'] })
            
            for ele in xml['config']['datasources']['source']:
                dsources.append({ 'name' : ele['@name'], 'type' : ele['@type'], 'id' : ele['@id'], 'port' : ele['@port'] })
        else:
            return None
                
        ar.close()        
        return [drivers,dsources]