import pycurl
import urllib
import xmltodict
import socket
try:
    from urllib.parse import urlencode
except ImportError:
    from urllib import urlencode

from StringIO import StringIO

class ARDILive:
    def __init__(self, core):
        self.core = core

    def UpdateLivePoint(self, asset, property, input, value):

        code = str(asset) + ':' + str(property) + ':' + input
        try:
            response = StringIO()

            fullurl = "http://" + self.core.server + ":" + self.core.port + "/api/sourcepush.php"

            post_data = {'asset': asset, code : value }            

            postfields = urlencode(post_data)            

            c = pycurl.Curl()
            c.setopt(c.URL,fullurl)
            c.setopt(c.WRITEFUNCTION,response.write)
            c.setopt(c.TIMEOUT,5)
            c.setopt(c.CONNECTTIMEOUT,3)
            c.setopt(c.POSTFIELDS,postfields)
            c.perform()
            c.close()
        except:
            #self.logger.error('Error Sending to Website')
            pass

        try:
            #Send Socket Request for Consolidation Server
            self.logger.debug("Updating Consolidation Server")

            #The socket connection to the consolidator
            self.client = socket.socket(socket.AF_INET,socket.SOCK_STREAM)
            self.client.connect((self.core.consolidatorhost,self.core.consolidatorport))            
            self.client.send(code + "=" + str(value) + "\r\n")

            self.client.close()
            #self.logger.debug("Update Complete!")
        except:
            #self.logger.error('Error Sending to Consolidation Server')
            pass

    def UpdateLivePoints(self, pointset):

        #print "Attempting Submission"
        try:
            response = StringIO()            

            fullurl = "http://" + self.core.server + ":" + self.core.port + "/api/sourcepush.php"

            post_data = {}#{'asset': asset }            

            for itm in pointset:
                code = str(itm[0]) + ':' + str(itm[1]) + ':' + itm[2]
                post_data[code] = itm[3]

            postfields = urlencode(post_data)            

            #print fullurl
            #print postfields

            c = pycurl.Curl()
            c.setopt(c.URL,fullurl)
            c.setopt(c.WRITEFUNCTION,response.write)
            c.setopt(c.TIMEOUT,5)
            c.setopt(c.CONNECTTIMEOUT,3)
            c.setopt(c.POSTFIELDS,postfields)
            c.perform()
            c.close()
        except:
            print 'Website Submission Error'
            #self.logger.error('Error Sending to Website')
            pass

        #try:
            #Send Socket Request for Consolidation Server
            #self.logger.debug("Updating Consolidation Server")

            #The socket connection to the consolidator
        self.client = socket.socket(socket.AF_INET,socket.SOCK_STREAM)
        self.client.connect((self.core.consolidatorhost,int(self.core.consolidatorport)))

        for itm in pointset:
            code = str(itm[0]) + ':' + str(itm[1]) + ':' + itm[2]
            self.client.send(code + "=" + str(itm[3]) + "\r\n")            

        self.client.close()
            #self.logger.debug("Update Complete!")
        #except:
            #self.logger.error('Error Sending to Consolidation Server')
        #    print 'Consolidation Server Error!'
        #    pass