import pycurl
import urllib
import xmltodict
try:
    from io import BytesIO
except ImportError:
    from StringIO import StringIO as BytesIO

class ARDIRelations:
    def __init__(self, core):
        self.core = core

    def Link(self,source,destination,relationship):

        final = urllib.urlencode({ 'origin' : source, 'destination' : destination, 'rel' : relationship })

        resp = []

        buffer = BytesIO()
        ar = pycurl.Curl()
        ar.setopt(ar.URL, 'http://' + self.core.server + ':' + str(self.core.port) + '/api/linkassets.php?' + final)
        ar.setopt(ar.WRITEFUNCTION, buffer.write)
        ar.perform()
        
        # HTTP response code, e.g. 200.
        if ar.getinfo(ar.RESPONSE_CODE) == 200:    
            xml = xmltodict.parse(buffer.getvalue())

            ar.close()
            
            try:
                res = xml['response']['success']
                return True
            except:
                return False            
            
        ar.close()
        return False

    def Unlink(self,source,destination,relationship):

        final = urllib.urlencode({ 'origin' : source, 'destination' : destination, 'rel' : relationship })

        resp = []

        buffer = BytesIO()
        ar = pycurl.Curl()
        ar.setopt(ar.URL, 'http://' + self.core.server + ':' + str(self.core.port) + '/api/unlinkassets.php?' + final)
        ar.setopt(ar.WRITEFUNCTION, buffer.write)
        ar.perform()
        
        # HTTP response code, e.g. 200.
        if ar.getinfo(ar.RESPONSE_CODE) == 200:    
            xml = xmltodict.parse(buffer.getvalue())

            ar.close()

            print xml;
            try:
                res = xml['response']['success']
                return True
            except:
                return False            
            
        ar.close()
        return False