import pycurl
import urllib
import xmltodict
import time
import traceback
import threading
import signal
import sys
import requests
from StringIO import StringIO

try:
    from urllib.parse import urlencode
except ImportError:
    from urllib import urlencode
    
class ARDISubscription:
    def __init__(self,core):
        self.core = core
        self.subscription = ""
        self.codes = []
        self.cancelled = False
        self.codechange = False
        self.threaded = True
        self.callback = None
        self.context = None
        self.closed = False

    def AddCode(self,address):
        self.codes.append(address)
        self.codechange = True

    def Connect(self):
        self.ThreadBody()

    def Disconnect(self):
        self.cancelled = True

    def Subscribe(self):
        self._call("subscribe")
        self.codechange = False
        if self.subscription != "":
            return True
        
        return False
    
    def SetCallback(self,call,cont):
        self.callback = call
        self.context = cont

    def Unsubscribe(self):
        self._call("unsubscribe")
        self.subscription = ""
        pass

    def Clear(self):
        if self.subscription != "":
            self.Unsubscribe()
        self.codes = []

    def Update(self):
        if self.codechange == True:
            self.Unsubscribe()
            self.Subscribe()
            return
        self._call("update")
        pass
    
    def _call(self,function):

        if (len(self.codes) == 0):
            time.sleep(1)
            return

        try:
            #print "  CURL Request"
            fullurl = self.core.server
            try:
                ps = fullurl.index(':')
                if ps > -1:
                    fullurl = fullurl[0:ps]
            except (KeyboardInterrupt, SystemExit):
                raise
            except:
                pass

            try:
                ps = fullurl.index('/')
                if ps > -1:
                    fullurl = fullurl[0:ps]
            except (KeyboardInterrupt, SystemExit):
                raise
            except:
                pass

            fullurl = "http://" + fullurl
            fullurl += ":" + self.core.contexts[0].consolidator
            fullurl += "/" + function

            #print fullurl

            anydata = False
            post_data = {}
            if function != "subscribe":
                post_data['id'] = self.subscription
                anydata = True

            if function == "subscribe":
                codelist = ""
                for itm in self.codes:
                    #print "Loading Code..."
                    if codelist != "":
                        codelist = codelist + ","
                    codelist += itm
                    anydata = True
                post_data['codes'] = codelist
                anydata = True

            if anydata == True:
                postfields = urlencode(post_data)
            try:
                response = StringIO()
                
                #signal.signal(signal.SIGINT,self.catchsignal)
                #signal.signal(signal.SIGTERM,self.catchsignal)
                if function == "subscribe":
                    r = requests.post(fullurl,data={'codes': codelist }, timeout=5)
                else:
                    r = requests.post(fullurl,data={'id': self.subscription }, timeout=30)
                #signal.signal(signal.SIGINT,signal.SIG_DFL)
                #signal.signal(signal.SIGTERM,signal.SIG_DFL)
                
                returned = {}

                try:
                    result = xmltodict.parse(r.text)
                except:
                    if function != "subscribe":
                        self._call("subscribe")
                        return True

                self.subscription = result['update']['id']
                try:
                    returned[result['update']['points']['point']['@code']] = result['update']['points']['point']['@value']
                except:
                    try:
                        for p in result['update']['points']['point']:
                           
                            returned[p['@code']] = p['@value']
                    except:
                        pass

               
                if self.callback is not None:
                    self.callback(returned,self.context)
            except pycurl.error as e:
                if e[0] == 23:
                    self.closed = True
                    #print "Marking Closed!"
                    return False
                if e[0] != 28:
                    traceback.print_exc()
                    return False
                else:
                    #print "Response Timeout"
                    return True
            except (KeyboardInterrupt, SystemExit):
                self.cancelled = True
                return False
            except:
                print("Failed To Send!")
                traceback.print_exc()
                return False
            return True
        
        except:
            traceback.print_exc()
            return False

    def ThreadBody(self):
        while self.cancelled == False:
            while self.subscription == "":
                if self.Subscribe() == False:
                    time.sleep(5)
                    if self.cancelled == True:
                        break;
                else:
                    break
            if self.cancelled == True:
                break;

            if self.Update():
                #Call the callback function with our new data...
                time.sleep(1)
                pass
            else:
                #No new data arrived - immediately try again.
                time.sleep(0.5)
                pass