#!/usr/bin/python

## @package ardi.consolidator.incoming
#
# Handles data coming in from ARDI live drivers.


from twisted.internet.protocol import Protocol

from twisted.internet.protocol import Factory
from twisted.internet.endpoints import TCP4ServerEndpoint
from twisted.internet import reactor
import logging

## Handles the submission of new data
#
#  This class is used to accept data from submission clients, such as ARDI itself or
#  live data drivers.
#
#  It is created by the SubmissionFactory, as part of the SubmissionService.
class Submission(Protocol):
    def __init__(self, factory):
        self.factory = factory
        pass

    def dataReceived(self,data):
        #logging.warning(data);
        try:
            data = data.decode('utf-8')
        except:
            pass
        dta = str(data)
        pieces = dta.split("\r\n");
        for pc in pieces:
            bits = pc.split('=')
            if len(bits) == 2:
                #print(bits[0] + ' = ' + bits[1])
                self.factory.service.core.NewDataArrived(bits[0],bits[1])

    def connectionMade(self):
        pass

    def connectionLost(self, reason):
        pass

## Produces a Submission Client Handler
#
#  The submission factory creates new Submission instances for each incoming submission connector.
#
#  It is used by SubmissionService.
class SubmissionFactory(Factory):
    def __init__(self,core):
        self.core = core

    def buildProtocol(self,addr):
        return Submission(self)

## The service for submitting live values
#
#  This service is launched by Twistd to handle incoming submission requests.
class SubmissionService:
    def __init__(self,core):
        self.core = core
        self.endpoint = None
        pass

    def run(self):
        endpoint = TCP4ServerEndpoint(reactor,5336)
        endpoint.listen(SubmissionFactory(self.core))
