import transform
import sys

print 'Performing Tests...'
sys.stdout.write('  Scaling: ')
#32500 - Input Range = 0-65535, Output Range = 0-100'
tx = transform.transform('SCALE|0|65535|0|100')
val = tx.run('32500')
if (val > 49.5) and (val < 49.6):
    print 'Success'
else:
    print 'FAILURE'


#print 'Test Binary Text Conversion - Input = 0, Converted To On/Off'
sys.stdout.write('  Binary to Text: ')
tx = transform.transform('BINARY|0|Off|1|On')
val = tx.run('0')
if val == 'Off':
    print 'Success'
else:
    print 'FAILURE'
    
#print 'Test Enumeration Conversion - Input = 3, Converted To Yes/No/Maybe/Perhaps/Ask Your Mother'
sys.stdout.write('  Match/Enumeration: ')
tx = transform.transform('MATCH|0|Yes|1|No|2|Maybe|3|Perhaps|4|Ask Your Mother')
val = tx.run('3')
if val == 'Perhaps':
    print 'Success'
else:
    print 'FAILURE'
    
#print 'Sign Fault - Input = 6553.3, 10x Multiplier'
sys.stdout.write('  Sign Fix: ')
tx = transform.transform('SIGNFIX|10')
val = tx.run('6553.3')
if val == -0.3:
    print 'Success'
else:
    print 'FAILURE'
    
#print 'Test Rounding - 22.567 - Rounded to 1 Decimal'
sys.stdout.write('  Rounding: ')
tx = transform.transform('ROUND|1')
val = tx.run('22.567')
if val == 22.6:
    print 'Success'
else:
    print 'FAILURE'
    
#print 'Test Low Cut - 0.02 - Cut Below 0.05'
sys.stdout.write('  Low Cut: ')
tx = transform.transform('LOWCUT|0.05')
val = tx.run('0.02')
if val == 0:
    print 'Success'
else:
    print 'FAILURE'
    
#print 'Test Offset - 75 - Offset of +5'
sys.stdout.write('  Offset/Zero: ')
tx = transform.transform('OFFSET|5')
val = tx.run('75')
if val == 80:
    print 'Success'
else:
    print 'FAILURE'
    
#print 'Test Multiple Item Interaction...'
print '  Multi Item Interaction: '
tx = transform.transform('OFFSET|-15^SCALE|0|3000|0|100^ROUND|1^LOWCUT|0.5')
sys.stdout.write('    100% Test (Offset + Scale): ')
val = tx.run('3015')
if val == 100:
    print 'Success'
else:
    print 'FAILURE'
    
val = tx.run('15')
sys.stdout.write('    0% Test (Offset + Scale): ')
if val == 0:
    print 'Success'
else:
    print 'FAILURE'

val = tx.run('20')
sys.stdout.write('    1% Test (Offset + Scale + Low Cut): ')
if val == 0:
    print 'Success'
else:
    print 'FAILURE'
    
val = tx.run('30')
sys.stdout.write('    2% Test (Offset + Scale + Low Cut + Rounding): ')
if val == 0.5:
    print 'Success'
else:
    print 'FAILURE'

print '  Enumeration From 0-100: '
tx = transform.transform('SCALE|0|100|0|12^ROUND|0^MATCH|0|Initialising|1|Manual|2|Stopping|3|Not Available|4|OK to Start|5|Fully Ready to Start|6|Starting|7|Ready to Sync|8|Generating|9|Moving to Sync-Con|10|Sync-Con|11|Moving to Generation')
sys.stdout.write('    Testing Zero: ')
val = tx.run('0')
if val == 'Initialising':
    print 'Success'
else:
    print 'FAILURE'

sys.stdout.write('    Testing Twenty: ')
val = tx.run('20')
if val == 'Stopping':
    print 'Success'
else:
    print 'FAILURE'

sys.stdout.write('  Boolean Point (Old Style): ')
sys.stdout.write('    10 vs 50: ')
tx = transform.transform('BPOINT|50')
val = tx.run('10')
if val == '0':
    print 'Success'
else:
    print 'FAILURE (' + str(val) + ')'

sys.stdout.write('    80 vs 50: ')
val = tx.run('80')
if val == '1':
    print 'Success'
else:
    print 'FAILURE'

sys.stdout.write(' Boolean Point (New Style): ')
sys.stdout.write('    10 vs 70: ')
tx = transform.transform('BPOINT|75|g')
val = tx.run('10')
if val == '0':
    print 'Success'
else:
    print 'FAILURE'

sys.stdout.write('    80 vs 70: ')
val = tx.run('80')
if val == '1':
    print 'Success'
else:
    print 'FAILURE'

sys.stdout.write('    Inverse 10 vs 70: ')
tx = transform.transform('BPOINT|75|l')
val = tx.run('10')
if val == '1':
    print 'Success'
else:
    print 'FAILURE'

sys.stdout.write('    80 vs 70: ')
val = tx.run('80')
if val == '0':
    print 'Success'
else:
    print 'FAILURE'