
!define FULLNAME Citect
!define DRIVERNAME citect

Name "ARDI Citect Driver"
Caption "ARDI Citect Driver"
Icon "${NSISDIR}\Contrib\Graphics\Icons\nsis1-install.ico"
OutFile "ARDI Citect Driver.exe"

InstallDir "$PROGRAMFILES\Optrix\ARDI"
InstallDirRegKey HKLM "Software\Optrix\ARDI" "InstallDir"

RequestExecutionLevel admin

BrandingText "Optrix Pty. Ltd, 2016-2017"

!include MUI2.nsh

;-------------------


!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_INSTFILES

Function MyFinishRun
ExecShell "" "$INSTDIR\Drivers\live\citect\notes.txt"
ExecShell "" "$INSTDIR\Drivers\live\citect"
FunctionEnd

!define MUI_FINISHPAGE_RUN
!define MUI_FINISHPAGE_RUN_FUNCTION MyFinishRun
!define MUI_FINISHPAGE_RUN_TEXT "Explain The Next Step"

!insertmacro MUI_PAGE_FINISH
!insertmacro MUI_LANGUAGE English

UninstPage uninstConfirm
UninstPage instfiles

;-------------------

AutoCloseWindow false
ShowInstDetails show

;-------------------

Section "Core Files"
  
  CreateDirectory "$INSTDIR\Drivers\live\citect"    
  
  SetOutPath $INSTDIR\Drivers\live\citect
  File "..\live\citect\citect.py"  
  File "..\live\citect\pyctapi.py"  
  File "..\live\citect\notes.txt"
  
  SetOutPath $INSTDIR\Web\data\live\${DRIVERNAME}
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\configure-source.php"
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\saveconfig-source.php"
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\info.inc"
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\link.php"
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\decode.php"
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\encode.php"
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\friendlyname.php"
      
  SetOutPath $INSTDIR\Drivers
  WriteUninstaller "uninstall-citect-driver.exe"  
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ARDI-Driver-Citect" "DisplayName" "ARDI Citect Driver"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ARDI-Driver-Citect" "UninstallString" '"$INSTDIR\uninstall-citect-driver.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ARDI-Driver-Citect" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ARDI-Driver-Citect" "NoRepair" 1
  
  SectionIn RO

SectionEnd

;--------------------------------

; Uninstaller

UninstallText "This will uninstall the ARDI Cirect Driver. Hit next to continue."
UninstallIcon "${NSISDIR}\Contrib\Graphics\Icons\nsis1-uninstall.ico"

Section "Uninstall"
	
	ReadRegStr $0 HKLM "Software\Python\PythonCore\2.7\InstallPath" ""
	
	DetailPrint "Removing Driver"
	RMDir /r $INSTDIR\Drivers\live\citect	
	
	DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ARDI-Driver-Citect"
	
SectionEnd
