
!define FULLNAME "Sine Wave"
!define DRIVERNAME sin

Name "ARDI ${FULLNAME} Driver"
Caption "ARDI ${FULLNAME} Driver"
Icon "${NSISDIR}\Contrib\Graphics\Icons\nsis1-install.ico"
OutFile "ARDI ${FULLNAME} Driver.exe"

InstallDir "$PROGRAMFILES\Optrix\ARDI"
InstallDirRegKey HKLM "Software\Optrix\ARDI" "InstallDir"

RequestExecutionLevel admin

BrandingText "Optrix Pty. Ltd, 2016-2017"

!include MUI2.nsh

;-------------------


!insertmacro MUI_PAGE_INSTFILES

!insertmacro MUI_PAGE_FINISH
!insertmacro MUI_LANGUAGE English

UninstPage uninstConfirm
UninstPage instfiles

;-------------------

AutoCloseWindow false
ShowInstDetails show

;-------------------

Section "Core Files"
  
  CreateDirectory "$INSTDIR\Drivers\live\${DRIVERNAME}"  
  CreateDirectory "$INSTDIR\Drivers\hist\${DRIVERNAME}"  
  CreateDirectory "$INSTDIR\Web\data\live\${DRIVERNAME}"  
  CreateDirectory "$INSTDIR\Web\data\historical\${DRIVERNAME}" 
  
  SetOutPath $INSTDIR\Drivers\live\text
  File "..\live\${DRIVERNAME}\${DRIVERNAME}.py"
  
  SetOutPath $INSTDIR\Drivers\hist\${DRIVERNAME}
  File "..\hist\${DRIVERNAME}\${DRIVERNAME}.py"
  
  SetOutPath $INSTDIR\Web\data\live\${DRIVERNAME}
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\configure-source.php"
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\saveconfig-source.php"
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\info.inc"
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\link.php"
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\decode.php"
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\encode.php"
  File "c:\wamp\ardi2\data\live\${DRIVERNAME}\friendlyname.php"
  
  SetOutPath $INSTDIR\Web\data\historical\${DRIVERNAME}
  File "c:\wamp\ardi2\data\historical\${DRIVERNAME}\configure-source.php"
  File "c:\wamp\ardi2\data\historical\${DRIVERNAME}\saveconfig-source.php"
  File "c:\wamp\ardi2\data\historical\${DRIVERNAME}\info.inc"
  File "c:\wamp\ardi2\data\historical\${DRIVERNAME}\link.php"
  File "c:\wamp\ardi2\data\historical\${DRIVERNAME}\decode.php"
  File "c:\wamp\ardi2\data\historical\${DRIVERNAME}\encode.php"
  File "c:\wamp\ardi2\data\historical\${DRIVERNAME}\friendlyname.php"
      
  SetOutPath $INSTDIR\Drivers
  WriteUninstaller "uninstall-${DRIVERNAME}-driver.exe"  
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ARDI-Driver-${DRIVERNAME}" "DisplayName" "ARDI ${FULLNAME} Driver"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ARDI-Driver-${DRIVERNAME}" "UninstallString" '"$INSTDIR\uninstall-${DRIVERNAME}-driver.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ARDI-Driver-${DRIVERNAME}" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ARDI-Driver-${DRIVERNAME}" "NoRepair" 1
  
  SectionIn RO

SectionEnd

;--------------------------------

; Uninstaller

UninstallText "This will uninstall the ARDI ${FULLNAME} Driver. Hit next to continue."
UninstallIcon "${NSISDIR}\Contrib\Graphics\Icons\nsis1-uninstall.ico"

Section "Uninstall"
	
	ReadRegStr $0 HKLM "Software\Python\PythonCore\2.7\InstallPath" ""
	
	DetailPrint "Removing Driver"
	RMDir /r $INSTDIR\Drivers\live\${DRIVERNAME}
	RMDir /r $INSTDIR\Drivers\hist\${DRIVERNAME}
	
	DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ARDI-Driver-${DRIVERNAME}"

	
SectionEnd
