import requests
import urllib
import xmltodict

class ARDIContext:
    def __init__(self):
        self.consolidator = 5336
        self.submission = 2991
        self.name = "Actual"
        self.server = ""        

class ARDICore:
    def __init__(self, srv,site = "default",secure=False):
        self.server = srv + "/s/" + site        
        self.webport = 80
        self.contexts = []
        self.prefix = "http"
        if secure == True:
            self.prefix = "https"

    def Connect(self):
        resp = requests.get(self.prefix + '://' + self.server + '/api/connect')
        
        # HTTP response code, e.g. 200.
        if resp.status_code == 200:            
            #print 'XML Content: ' + buffer.getvalue()
            xml = xmltodict.parse(resp.text)
            
            for d in xml['ardi']['service']:
                #print 'Checking ' + d['@name']
                if d['@name'] == 'data':
                    prt = 5336
                    src = self.server
                    try:
                        prt = d['@port']
                    except:
                        pass
                    
                    try:
                        src = d['@host']
                    except:
                        pass                

                    ctx = ARDIContext()
                    ctx.consolidator= prt
                    ctx.server = src
                    ctx.name = "Actual"
                    self.contexts.append(ctx)
            return True
        else:            
            return False        
        

    def GetConfiguration(self):
        resp = requests.get(self.prefix + '://' + self.server + ':' + str(self.port) + '/api/getconfiguration.php')
        
        # HTTP response code, e.g. 200.
        if resp.status_code == 200:
            #print buffer.getvalue()
            xml = xmltodict.parse(resp.text)

            rels = []
            props = []

            for ele in xml['config']['relations']['relationship']:
                rels.append({ 'name': ele['@name'], 'id': ele['@id'] })                
            
            for ele in xml['config']['properties']['property']:
                props.append({ 'name' : ele['@name'], 'type' : ele['@type'], 'id' : ele['@id'] })
        else:
            return None
                    
        return [rels,props]

    def GetDataSourceInfo(self):
        resp = requests.get(self.prefix + '://' + self.server + ':' + str(self.port) + '/api/getdatasources.php')

        # HTTP response code, e.g. 200.
        if resp.status_code == 200:            
            xml = xmltodict.parse(resp.text)

            drivers = []
            dsources = []

            for ele in xml['config']['drivers']['driver']:
                drivers.append({ 'name': ele['@name'], 'port': ele['@port'], 'code' : ele['@code'] })
            
            for ele in xml['config']['datasources']['source']:
                dsources.append({ 'name' : ele['@name'], 'type' : ele['@type'], 'id' : ele['@id'], 'port' : ele['@port'] })
        else:
            return None
                
        return [drivers,dsources]
