import os
import traceback
import threading
import argparse
import requests
import sys
import signal
import logging
import platform
import time
import pycurl
from ardi.api import core, subscription
from StringIO import StringIO

def CatchSignal(a,b):
    signal.signal(signal.SIGINT,signal.SIG_DFL)
    signal.signal(signal.SIGTERM,signal.SIG_DFL)
    note.Stop()
    
class ARDIService(object):

    def __init__(self):
        self.description = 'Template ARDI Service'
        self.addon = 'template'
        self.lastsignature = ''
        self.changethread = None
        self.ardithread = None
        self.signalhandler = None
        self.lastsignature = ""
        self.running = True
        self.channels = []

    def initlogger(self):

        """Initialises the historian logger"""
        if hasattr(self,'logger'):
            self.logger.info('----RELOAD----')
        else:
            logging.basicConfig(level=logging.INFO)
            ##The logger used to record information about the driver process as a whole
            self.logger = logging.getLogger(__name__)
            
            fname = "/var/log/ardi/" + self.addon + "-" + self.instancename + ".log"
            if (platform.system() == 'Windows'):
                fname = "c:\\windows\\temp\\ardi-" + self.addon + "-" + self.instancename + ".log"

            loghandler = logging.FileHandler(fname)
            loghandler.setLevel(logging.INFO)

            # create a logging format
            
            formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
            loghandler.setFormatter(formatter)
            
            # add the handlers to the logger
            
            self.logger.addHandler(loghandler)

            logging.getLogger("urllib3").setLevel(logging.WARNING)
            logging.getLogger("requests").setLevel(logging.WARNING)

            self.logger.info('----RESTART----')
            self.logger.info('Starting ' + self.addon + ' Process')

    def loadfromserver(self):
        self.initlogger()
        #print "Logger Initialised"
        while True:
            try:
                 self.logger.info("Requesting Configuration")
                 servername = self.server + "/s/" + self.instancename
                 response = StringIO()

                 if self.lastsignature == "":
                     self.logger.info('Checking for previous signature...')
                     fullurl = "http://" + servername + "/" + self.addon + "/api/version?trusted=true"
                     #print "Requesting " + fullurl
                     c = pycurl.Curl()
                     c.setopt(c.URL,fullurl)
                     c.setopt(c.WRITEFUNCTION,response.write)
                     c.setopt(c.TIMEOUT,5)
                     c.setopt(c.CONNECTTIMEOUT,5)
                     c.perform()
                     ret = response.getvalue()
                     c.close()

                     self.lastsignature = ret

                 config = self.GetConfiguration(servername)
                 if config != False:
                     self.ProcessConfiguration(config)
                     break

            except (KeyboardInterrupt, SystemExit):
                raise
            except:
                 traceback.print_exc()
                 time.sleep(10)
                 pass

    def GetConfiguration(self,servername):
        pass

    def ProcessConfiguration(self,config):
        try:
            signal.signal(signal.SIGINT,self.signalhandler)
            signal.signal(signal.SIGTERM,self.signalhandler)
        except:
            pass

    def startchangemonitor(self):
        self.changethread = threading.Thread(target=self.CheckForChanges)
        self.changethread.daemon = True
        self.changethread.start()

    def CheckForChanges(self):
        while self.running == True:
            time.sleep(20)
            #self.logger.info("Checking server for updates...")

            response = StringIO()
            try:
                fullurl = "http://" + self.server + "/" + self.addon + "/api/version?trusted=true"
                c = pycurl.Curl()
                c.setopt(c.URL,fullurl)
                c.setopt(c.WRITEFUNCTION,response.write)
                c.setopt(c.TIMEOUT,5)
                c.setopt(c.CONNECTTIMEOUT,5)
                c.perform()
                ret = response.getvalue()
                c.close()

                if ret != self.lastsignature:
                    self.logger.info("Updating with New Server Data")
                    self.lastsignature = ret
                    self.Sub.Clear()
                    self.loadfromserver()
                    for no in self.channels:
                        self.logger.info('  Listening To ' + no.ardi)
                        self.Sub.AddCode(no.ardi)
                    
                    self.Sub.Subscribe()
            except (KeyboardInterrupt, SystemExit):
                raise
            except:
                pass

    def ProcessNewValues(self,code,params):
        pass

    def startardimonitor(self):
        self.ardithread = threading.Thread(target=self.WatchLoop)
        self.ardithread.daemon = True
        self.ardithread.start()

    def WatchLoop(self):
        Cr = core.ARDICore(self.server, self.instancename)
        Cr.Connect()

        self.Sub = subscription.ARDISubscription(Cr)
        for no in self.channels:
            self.logger.info('  Listening To ' + no.ardi)
            self.Sub.AddCode(no.ardi)

        self.Sub.SetCallback(self.ProcessNewValues,False)
        try:
            self.Sub.Connect()
        except (KeyboardInterrupt, SystemExit):
            raise
        except:
            traceback.print_exc()

    def Stop(self):
        self.logger.info("Shutting Down...")
        self.running = False
        
    def BlockTillEnd(self):
        while self.running == True:
            try:
                time.sleep(1)
            except (KeyboardInterrupt, SystemExit, IOError):
                self.logger.info("Shutdown Signal Received")
                if self.running == True:
                    try:
                        self.Stop()
                    except:
                        traceback.print_exc()
                    finally:
                        pass
                break
            except:
                traceback.print_exc()
                
        self.logger.info("Main Loop Closed")

    def Start(self):
        parser = argparse.ArgumentParser(description=self.description)
        if platform.system() != "Windows":
            parser.add_argument('service', help='The instruction you would like to give the service')
        parser.add_argument('server', help='The ARDI server/site URL to use')

        args = parser.parse_args()

        self.server = args.server
        self.instancename = "default"
        ps = args.server.rfind('/')
        #print "Connecting to Server: " + args.server
        if ps > 0:
        self.instancename = args.server[ps+1:]
            self.server = args.server[:args.server.find('/')]
            #print self.server + " / " + self.instancename

        if platform.system() == 'Windows':
            #Daemonise this...
            self.loadfromserver()
            self.startchangemonitor()
            self.startardimonitor()
            pass
        else:
            #Just run - no need to daemonise.
            #print "Trying to daemonise this thing!"
                
            class Daemon:
                def __init__(self,instance):
                    self.base = instance
                    inst = self.base.instancename
                    self.addon = self.base.addon
                    
                    self.stdin_path = '/dev/null'
                    self.stdout_path = '/var/log/ardi/' + self.base.addon + "-" + instance.instancename
                    self.stderr_path = '/var/log/ardi/' + self.base.addon + "-" + instance.instancename
                    self.pidfile_path =  '/var/run/ardi-' + self.base.addon + "-" + instance.instancename
                    self.pidfile_timeout = 5
                    
                def run(self):
                    self.base.loadfromserver()
                    self.base.startchangemonitor()
                    self.base.startardimonitor()
                    try:
                        self.base.Started()
                    except:
                        pass
                    self.base.BlockTillEnd()
                    
            if args.service == "stop":
                from daemon import runner
                dm = Daemon(self)
                daemon_runner = runner.DaemonRunner(dm)
                daemon_runner.do_action()
                return False
                    
            if args.service != "standalone":
                from daemon import runner
                dm = Daemon(self)
                daemon_runner = runner.DaemonRunner(dm)
                daemon_runner.do_action()
            else:
                self.loadfromserver()
                self.startchangemonitor()
                self.startardimonitor()
                try:
                    self.Started()
                except:
                    pass
                self.BlockTillEnd()
            pass
        
        return True