try:
	import SocketServer
except:
	import socketserver as SocketServer

## @package ardi.driver.ipcservice
#  HTTP server for the DriverBase (Live Drivers)
#
# This socket server handles requests from ARDI.
#

## Live IPC Message Handler
#
#    This class responds to commands that are issued from server applications such as ARDI.
#
##    Some commands operate on the driver as a whole, while others operate on a single core """
class IPCHandler(SocketServer.StreamRequestHandler):

    ## Handles Incoming Commands
    #
    #    This function reads from the incoming stream and response appropriately."""
    def handle(self):

        ##A single incoming command
        #print("Processing IPC Message")
        self.data = self.rfile.readline().strip()
        try:
                cmd = self.data.decode('utf-8').strip()
        except:
                cmd = self.data.strip()
        cmd = cmd.split('|')

        context = 1
        if len(cmd) > 2:
                try:
                        context = int(cmd[len(cmd)-1])
                except:
                        pass
        
        #print('Incoming Command: ' + str(cmd))
        try:
            if cmd[0] == 'pause':
                if len(cmd) > 1:
                    self.server.core.Pause(cmd[1],context)
            if cmd[0] == 'resume':
                if len(cmd) > 1:
                    self.server.core.Resume(cmd[1],context)
            if cmd[0] == 'spinup':
                if len(cmd) > 1:
                    self.server.core.Spinup(cmd[1],context)
            if cmd[0] == 'reload':
                if len(cmd) > 1:
                    self.server.core.Reload(cmd[1],context)
            if cmd[0] == 'uprate':
                if len(cmd) > 2:                    
                    self.server.core.SetUpdateRate(cmd[1],cmd[2],context)                
            if cmd[0] == 'spindown':
                self.server.core.Restart()
            if cmd[0] == 'restart':
                self.server.core.Restart()
            if cmd[0] == 'debug':
                self.server.core.DebugMode(cmd[1],cmd[2])
            if cmd[0] == 'status':
                stat = self.server.core.ShowStatus()
                self.wfile.write(stat.encode())
            if cmd[0] == 'trace':
                stat = self.server.core.StartTracing(cmd[1])                
            if cmd[0] == 'log':
                cr = 0
                if len(cmd) > 1:                        
                        cr = int(cmd[1])                
                stat = self.server.core.ShowLog(cr,context,'basic')
                self.wfile.write(stat.encode())
            if cmd[0] == 'dlog':
                cr = 0
                if len(cmd) > 1:
                        cr = int(cmd[1])
                stat = self.server.core.ShowLog(cr,context,'detail')
                self.wfile.write(stat.encode())
            if cmd[0] == 'issues':
                print("Requesting Issues")
                cr = 0
                if len(cmd) > 1:
                        cr = int(cmd[1])
                stat = self.server.core.ShowIssues(cr,context)
                self.wfile.write(stat.encode())
        except Exception as e:
            print("Exeption Processing Command: " + str(e))
            pass

## Live IPC (Socket) server to control a driver
#
#    This class listens for socket connections and responds to commands from controlling applications (such as ARDI)
#
#    Some commands operate on the driver as a whole, while others operate on a single core
class DriverIPC:
    ## Intialises the IPC Connection
    def __init__(self):

        ##The TCPServer instance that represents this service
        self.service = None

        ##The port that this IPC service should run on
        self.port = 9001

        ##A reference to the drivercore that spawned this IPC service
        self.core = None
        pass

    ## Start the IPC Service
    #
    #    This command starts the TCPServer that listens for incoming commands
    def start(self):
        SocketServer.TCPServer.allow_reuse_address = 1
        self.service = SocketServer.TCPServer(("",self.port),IPCHandler)
        self.service.core = self.core
        
        self.core.logger.info("Initialising Driver IPC Service on port " + str(self.port))
        try:
            self.service.serve_forever()
        except:
            self.core.logger.exception("Shutting Down IPC Service")
            pass

        try:
            self.service.server_close()
        except:
            pass
