## @package ardi.driver.resultstore
#  Deprecated Package for Historian Result Storage
#
#  @deprecated This package was made redundant by the new historianquery2 interface.
#
import pycurl
import xmltodict
import time
import socket
import ardi.driver.transform
import platform
import traceback

import logging
import threading
import datetime
from datetime import timedelta

import traceback

class ResultItem:
    def __init__(self):
        self.stamp = None
        self.value = None

## A set of results from a Historian
#
#  @deprecated The functionality of this class has been rolled into historianquery2.
#
#  This class was used to store the results of a Historian query.
class ResultStore:
    def __init__(self):
        self.rows = {}

    def Record(self,id,stamp,value):
        #print "Placing" + str(rec.value) + " for " + str(rec.stamp) + " > " + str(id)
        if id not in self.rows:
            self.rows[id] = []
            
        rec = ResultItem()
        if not isinstance(stamp, datetime.datetime):
            #strip milliseconds from datetime...
            vd = str(stamp)
            ps = vd.rfind('.')
            if ps != -1:
                vd = vd[0:ps]
            stamp = datetime.datetime.strptime( vd, "%Y-%m-%d %H:%M:%S" )
            
        rec.stamp = stamp 
        rec.value = value
        #print "Storing " + str(rec.value) + " for " + str(rec.stamp) + " > " + str(id)
        self.rows[id].append(rec)

    def Interpolate(self,spacing,spaces):
        print("Interpolating Data...")

    def Calculate(self,function):
        #n=0
        for key in self.rows:
            ttl = 0
            mx = -99999
            mi = 99999
            for v in self.rows[key]:
                if v.value > mx:
                    mx = v.value
                if v.value < mi:
                    mi = v.value
                ttl = ttl + v.value
            ttl = ttl / len(self.rows[key])
            self.rows[key] = []

            if function == "average":
                self.Record(key,datetime.datetime.today(),ttl)
                #self.rows[key].append(ttl)
            if function == "min":
                self.Record(key,datetime.datetime.today(),mi)
                #self.rows[key].append(mi)
            if function == "max":
                self.Record(key,datetime.datetime.today(),mx)
                #self.rows[key].append(mx)
            #n=n+1

    def Prepare(self,function, grain, start, end, driver, points):
        if function == "avg":
            self.Calculate("average")
            return self.Output(driver,points)
        if function == "min":
            self.Calculate("min")
            return self.Output(driver,points)
        if function == "max":
            self.Calculate("max")
            return self.Output(driver,points)

        try:
            self.Fit(start,end)
        except:
            traceback.print_exc()
        return self.Output(driver,points)

    def Fit(self, start, end):
        #print "Fitting Data"
        
        for key in self.rows:
            first = self.rows[key][0]

            if first.stamp > start:
                vv = ResultItem();
                vv.stamp= start
                vv.value = self.rows[key][0].value
                self.rows[key].insert(0,vv)
                            
            try:
                second = self.rows[key][1]
                diff = second.stamp - first.stamp
            
                ttl = diff.total_seconds()
                offset = (start - first.stamp).total_seconds()

                if ttl==0:
                    perc = 0
                else:
                    perc = offset / ttl

                if perc != 1:
                    self.rows[key][0].stamp = start
                    self.rows[key][0].value = (float(first.value) * (1-perc)) + (float(second.value) * (perc))
            except:
                #traceback.print_exc()
                self.rows[key][0].stamp = start
                vv = ResultItem();
                vv.stamp= end
                vv.value = self.rows[key][0].value
                self.rows[key].append(vv)
                #print "Only One Record Present"
                return;

            first = self.rows[key][len(self.rows[key])-2]
            second = self.rows[key][len(self.rows[key])-1]
            
            #if not isinstance(first.stamp, datetime.datetime):
            #    ed = datetime.datetime.strptime( first.stamp, "%Y-%m-%d %H:%M:%S" )
            #else:
            ed = first.stamp

            #if not isinstance(second.stamp, datetime.datetime):
            #    sd = datetime.datetime.strptime( second.stamp, "%Y-%m-%d %H:%M:%S" )
            #else:
            sd = second.stamp

            diff = ed - sd

            if sd > end:

                ttl = diff.total_seconds()
                offset = (sd - end).total_seconds()

                perc = (offset / ttl)

                if perc == 1:
                    self.rows[key][len(self.rows[key])].stamp = end
                    self.rows[key][len(self.rows[key])].value = (second.value * (1-perc)) + (first.value * (perc))

                #print "Adjusting End"
            else:
                #print "Padding End"
                vv = ResultItem();
                vv.stamp= end
                vv.value = self.rows[key][len(self.rows[key])-1].value
                self.rows[key].append(vv)

    def Output(self,driver,points):
        #print "Outputting Results..."

        lookuptable = {}
        x=-1
        for itm in points:
            x = x+1
            lookuptable[str(itm)] = x
            
        #print str(self.rows)
        
        out = ""
        for key in self.rows:
            n = lookuptable[key]
            for v in self.rows[key]:
                vl = v.value
                if (str(vl) == "None"):
                    vl = "0"
                out = out + driver.core.AddRecord(n,v.stamp,vl,points[n])
            
        #print out.encode('ascii')
        return out.encode('ascii')
