## @package ardi.driver.sqlhelper
#  Deprecated Package for SQL Historians
#
#  @deprecated This package was not successful due to different optimisations required for various database vendors.
#
#  This class was inteded to provide a generic SQL statement producer to make python-compliant database driver development almost effortless.
#
#  While it worked in a limited sense, the different types of optimisation required for each different DBO required vastly different SQL statements. As such, the class was abandoned.
#
#  SQLHelper remains in the repository in the hope that one day it may be revived, but it is NOT for use.
#
import pycurl
import xmltodict
import time
import socket
import transform
import platform
import traceback

import logging
import threading
import pytz
from tzlocal import get_localzone
import datetime
from datetime import timedelta
from ardi.driver import resultstore

## Deprecated Class SQL Historians
#
#  @deprecated This class is not intended for use. It may be investigated again in the future.
#
class SQLSource:
    def __init__(self,db,driver):
        self.db = db
        self.driver = driver
        self.core = driver
        self.filter = ""
        self.narrowthreshold = 20
        self.datepoints = 4
        self.server = "mysql"		
        self.upperedgequery = "SELECT {stamp}, {lookup}, {value} FROM ( SELECT * FROM {table} WHERE {stamp} <= {start}{additional} ORDER BY {stamp} DESC) AS t1 GROUP BY {lookup}";
        self.loweredgequery = "SELECT {stamp}, {lookup}, {value} FROM ( SELECT * FROM {table} WHERE {stamp} >= {end}{additional} ORDER BY {stamp} DESC) AS t1 GROUP BY {lookup}";
        self.mainquery = "SELECT {extra} as ostamp, {lookup} as lookup, AVG({value}) as value FROM {table} WHERE {stamp}>={start} AND {stamp}<={end}{additional} GROUP BY ostamp, lookup ORDER BY ostamp,lookup"
        self.datetimecalc = "DATE_ADD('{start}',INTERVAL (CEIL(TIMESTAMPDIFF(SECOND,'{start}',{stamp}) / {grain}) * {grain}) SECOND)"
        self.numericcalc = "CEIL(({stamp} - {start}) / {grain}) * {grain}"
        self.tableprefix = ""
        #self.filetimecalc = "CEIL(({stamp} - {start}) / {grain}) * {grain}"

        self.datestyle = "1"
        self.tz = "local"
        self.localtz = get_localzone()
        self.options = ""

    def ConnectionParameters(self,host,username,password,database):
        self.host = host
        self.username = username
        self.password = password
        self.database = database

    def TableParameters(self,stamp, lookup, value,table,filter=""):
        self.table = table
        self.stamp = stamp
        self.lookup = lookup
        self.value = value
        self.filter = filter

    def Reconnect(self):
        return self.driver.Connect()
        pass

    def TranslateDT(self,dt):
    	#Traditional date...
    	if self.datestyle == "1":
    		return "'" + str(dt) + "'";
    	
    	#UNIX Epoch
    	if self.datestyle == "2":
    		if self.tz != "UTC":
    			dt = self.localtz.localize(dt)
    			dt = dt.astimezone(pytz.UTC)
    		return str(long((dt - datetime.datetime(1970,1,1,0,0,0,0,pytz.UTC)).total_seconds()))
    	
    	#Win32 FILETIME
    	if self.datestyle == "3":
    		tickspersec = 10000000
    		if self.tz != "UTC":
    			dt = self.localtz.localize(dt)
    			dt = dt.astimezone(pytz.UTC)
    		l = long((dt - datetime.datetime(1601,1,1,0,0,0,0,pytz.UTC)).total_seconds())
    		return str(l * tickspersec);
    	
    	#CLR Time
    	if self.datestyle == "4":
    		tickspersec = 10000000
    		if self.tz != "UTC":
    			dt = self.localtz.localize(dt)
    			dt = dt.astimezone(pytz.UTC)
    		diff = (dt - datetime.datetime(1,1,1,0,0,0,0,pytz.UTC)).total_seconds()
    		return str(long(tickspersec) * long(diff));

    def ConvertDateBack(self,dt):
    	#Traditional date...
    	if self.datestyle == "1":
    		return dt;

    	#UNIX Epoch
    	if self.datestyle == "2":
    		dd = datetime.datetime.utcfromtimestamp(long(dt)).replace(tzinfo=pytz.UTC)
    		return dd.astimezone(self.localtz).replace(tzinfo=None)
    	
    	#Win32 FILETIME
    	if self.datestyle == "3":
    	    tickspersec = 10000000
    	    l = long(dt) / tickspersec
    	    dvx = (datetime.datetime(1970,1,1,0,0,0,0,pytz.UTC) - datetime.datetime(1601,1,1,0,0,0,0,pytz.UTC)).total_seconds()
    	    l -= dvx
    	    #print "Final Timestamp: " + str(l)
    	    dd = datetime.datetime.utcfromtimestamp(l).replace(tzinfo=pytz.UTC)
    	    return dd.astimezone(self.localtz).replace(tzinfo=None)
    	
    	#CLR Time
    	if self.datestyle == "4":
    		tickspersec = 10000000
    		diff = long(dt) / tickspersec
    		tstamp = datetime.datetime(1970,1,1,0,0,0,0,pytz.UTC)
    		dvx = (datetime.datetime(1970,1,1,0,0,0) - datetime.datetime(1,1,1,0,0,0)).total_seconds()
    		#print "Total Seconds: " + str(long(dvx))
    		dd = datetime.datetime.utcfromtimestamp(diff - dvx).replace(tzinfo=pytz.UTC)
    		return dd.astimezone(self.localtz).replace(tzinfo=None)

    def Substitute(self, stx, grain, start, end, additional,extra):
    	stx = stx.replace("{stamp}",self.stamp)
    	stx = stx.replace("{additional}",additional)
    	stx = stx.replace("{lookup}",self.lookup)
    	stx = stx.replace("{value}",self.value)
    	stx = stx.replace("{table}",self.table)
    	
    	stx = stx.replace("{grain}",str(grain))
    	stx = stx.replace("{extra}",extra)
    	stx = stx.replace("{start}",start)
    	stx = stx.replace("{end}",end)
    	return stx

    def Fetch(self, sd, ed, function, grain, points):
        Results = resultstore.ResultStore()

        #print("Beginning Fetch")

        qsd = self.TranslateDT(sd)
        qed = self.TranslateDT(ed)

        if self.tz == "local":
            self.localtz = get_localzone()
        else:
            if self.tz == "UTC":
                self.localtz = pytz.UTC
            else:
                self.localtz = pytz.timezone(self.tz)

        fullquery = ""

        try:
            #print("Checking Commit")
            self.db.commit()
        except:
            #print("Commit Failure - Reconnecting")
            traceback.print_exc()
            self.driver.Connect()
            self.db = self.driver.db

        #Figure out effective grain...

        diff = ed - sd

        #secs = diff.seconds + (diff.minutes * 60) + (diff.hours * (60*60)) + (diff.days * (60*60*24))
        secs = diff.total_seconds()
        #self.options = "snapshot"

        itemcount = int(secs) / int(grain)
        if int(grain) < 0:
            #print "Dealing With Negative Grain"
            itemcount = -int(grain)
            grain = secs / (itemcount)

        if (self.datestyle == "4") or (self.datestyle == "3"):
        	grain = long(grain * 10000000)

        add = ""
        if self.filter != "":
            add += " AND (" + self.filter + ")"

        if len(points) < self.narrowthreshold:
            add += " AND (" + self.tableprefix + self.lookup + " IN ("
            x=0
            for p in points:
                if x > 0:
                    add += ","
                add += "'" + p + "'"
                x = x + 1
            add += "))"

        if self.options == "snapshot":
            #Use the snapshot topoff query
            topoffquery = 'SELECT MAX(' + self.stamp + ') as mx FROM ' + self.table + ' WHERE ' + self.stamp + " <= " + qsd
            NoDate = False
            try:
                csr = self.db.cursor()
                csr.execute(topoffquery);
            except:
                traceback.print_exc()
                self.driver.Connect()
                self.db = self.driver.db
                try:
                    csr = self.db.cursor()
                    csr.execute(topoffquery);
                except:
                    traceback.print_exc()
                    return ""

            for row in csr:
                mx = row[0]

            topoffquery = 'SELECT ' + self.stamp + ', ' + self.lookup + ', ' + self.value + ' FROM ' + self.table + ' WHERE ' + self.stamp + ' = '
            vd = str(mx)
            if vd == "None":
                NoDate = True
            else:
                if self.datestyle == "1":
                    ps = vd.rfind('.')
                    if ps != -1:
                        if len(vd) > ps+self.datepoints:
                            vd = vd[0:ps+self.datepoints]

                    topoffquery += "'" + vd + "'"
               
                else:
                    topoffquery += str(mx)
                
            topoffquery += add
            if NoDate == False:
                if self.tableprefix != "":
                    topoffquery = topoffquery.replace(self.tableprefix,"")
                self.driver.core.logger.debug("**Pre-Fetch Query: " + topoffquery)
                
                try:
                    csr = self.db.cursor()
                    csr.execute(topoffquery);
                except:
                    traceback.print_exc()
                    return ""

                for row in csr:
                    if row[1] in points:
                        #print str(row)
                        dt = self.ConvertDateBack(row[0])
                        Results.Record(str(row[1]),dt,row[2])

        else:
            #Use the topoff query
            topoffquery = self.Substitute(self.upperedgequery,grain,qsd,qed,add,"<=")
            self.driver.core.logger.info("**Pre-Fetch Query: " + topoffquery)
            fullquery += topoffquery
            try:
                csr = self.db.cursor()
                csr.execute(topoffquery);
            except:
                traceback.print_exc()
                self.driver.Connect()
                self.db = self.driver.db
                try:
                    csr = self.db.cursor()
                    csr.execute(topoffquery);
                except:
                    return ""

            for row in csr:
                if row[1] in points:
                    #print str(row)
                    dt = self.ConvertDateBack(row[0])
                    Results.Record(str(row[1]),dt,row[2])

            csr.close()

        #print "Pre-Fetch Complete"

        if (sd != ed):

            code = ""
            self.driver.core.logger.debug("Date Style: " + self.datestyle)
            if self.datestyle == "1":                
                code = self.Substitute(self.datetimecalc,grain,qsd,qed,add,"")
                #print(code)
            else:
               code = self.Substitute(self.numericcalc,grain,qsd,qed,add,"")
                
            self.query = self.Substitute(self.mainquery,grain,qsd,qed,add,code)
            self.driver.core.logger.info("Main Query: " + self.query)

            try:
                #print self.query
                csr = self.db.cursor()
                #print str(points)

                csr.execute(self.query)		
                for row in csr:
                    #print "Rows - '" + row[1] + "'"
                    if row[1] in points:
                        print(str(row))
                        dt = self.ConvertDateBack(row[0])
                        Results.Record(str(row[1]),dt,row[2])

                csr.close()
            except:
                print(self.query)
                traceback.print_exc()
                pass

        #Get the NEXT values so we have something to interpolate into...
        if self.options == "snapshot":
            #Use the snapshot topoff query
            topoffquery = 'SELECT MIN(' + self.stamp + ') as mx FROM ' + self.table + ' WHERE ' + self.stamp + " >= " + qsd
            NoDate = False
            try:
                csr = self.db.cursor()
                csr.execute(topoffquery);
            except:
                traceback.print_exc()
                self.driver.Connect()
                self.db = self.driver.db
                try:
                    csr = self.db.cursor()
                    csr.execute(topoffquery);
                except:
                    traceback.print_exc()
                    return ""

            for row in csr:
                mx = row[0]

            topoffquery = 'SELECT ' + self.stamp + ', ' + self.lookup + ', ' + self.value + ' FROM ' + self.table + ' WHERE ' + self.stamp + ' = '
            vd = str(mx)
            if vd == "None":
                NoDate = True
            else:
                if self.datestyle == "1":
                
                    ps = vd.rfind('.')
                    if ps != -1:
                        if len(vd) > ps+self.datepoints:
                            vd = vd[0:ps+self.datepoints]
                    
                        topoffquery += "'" + vd + "'"
                
                else:
                    topoffquery += str(mx)
                
            topoffquery += add
            if NoDate == False:
                if self.tableprefix != "":
                    topoffquery = topoffquery.replace(self.tableprefix,"")
                self.driver.core.logger.debug("Post-Fetch Query: " + topoffquery)
                
                try:
                    csr = self.db.cursor()
                    csr.execute(topoffquery);
                except:
                    traceback.print_exc()
                    return ""

                for row in csr:
                    if row[1] in points:
                        #print str(row)
                        dt = self.ConvertDateBack(row[0])
                        Results.Record(str(row[1]),dt,row[2])

        else:
            topoffquery = self.Substitute(self.loweredgequery,grain,qsd,qed,add,"<=")
            self.driver.core.logger.debug("Post-Fetch Query: " + topoffquery)
            try:	
                csr = self.db.cursor()
                csr.execute(topoffquery);
            
                #OK - same deal, but this time get the NEXT row value from each...

                for row in csr:
                    if row[1] in points:
                        #print str(row)
                        dt = self.ConvertDateBack(row[0])        	        
                        Results.Record(str(row[1]),dt,row[2])
                    pass

                csr.close()
            except:
                self.driver.core.logger.exception("Failed To Add")            
                pass

        try:
        	self.db.commit()
        except:
        	pass

        #print "Returning..."

        return Results.Prepare(function,grain,sd,ed,self.core,points)
