import datetime
import traceback
import pytz
import json
import re

class output:
    def __init__(self,config):        
        self.config = config
        self.constring = config['constring']        
        self.domain = config['domain']
        self.sender = "NoReply"
        if 'sender' in config:
            self.sender = config['sender']
            
        self.subject = '%M'        
        self.timezone = "UTC"
        self.content = "<h3>%M</h3><p>%S to %E</p>"
        if 'subject' in config:
            self.subject = config['subject']
        if 'content' in config:
            self.content = config['content']

        self.toaddr = config['to']            

        if 'format' in config:
            self.format = config['format']

        if 'timezone' in config:
            self.timezone = config['timezone']

        if 'dateformat' in config:
            self.dateformat = config['dateformat']

        self.tz = pytz.timezone(self.timezone)

    def Initialise(self):  
        try:
            from azure.communication.email import EmailClient            
        except:
            print("'azure-communication-email' Python Module Must Be Installed")
            return False
        return True    

    def Supports(self,nm):        
        return False

    def StripHTML(self,st):        
        return re.sub('<[^<]+?>', '', st)

    def Write(self,name,duration,offset,options=None): 
        try:            
            
            from azure.communication.email import EmailClient
            client = EmailClient.from_connection_string(self.constring)

            # Create the plain-text and HTML version of your message
            html = self.host.Format(self,self.content,name,duration,offset,options)
            text = self.StripHTML(name)

            message = {
                "senderAddress": self.sender + "@" + self.domain,
                "recipients":  {
                    "to": [{"address": self.toaddr}],
                },
                "content": {
                    "subject": self.host.Format(self,self.subject,name,duration,offset,options),
                    "plainText": text,
                    "html": html
                }
            }      
            
            #print("Email Subject: " + message['content']['subject'])

            poller = client.begin_send(message)
            result = poller.result()

            return True
                
        except:
            traceback.print_exc()
            return False

    def Close(self):
        pass
