import simpleaudio as sa
import pyttsx3
import time
import requests
import json
import datetime
import traceback

class output:
    def __init__(self,config):                
        self.config = config        
        self.format = "%M"
        self.presound = False
        
        if 'presound' in config:
            self.presound = config['presound']
        if 'format' in config:
            self.format = config['format']

    def Initialise(self): 
        self.engine = pyttsx3.init()
        self.engine.setProperty('rate',150)
        return True    

    def Supports(self,nm):        
        return False

    def Write(self,name,duration,offset,options=None): 
        try:                      
            msg = self.host.Format(self,self.format,name,duration,offset,options)    
            if self.presound is not None:
                presound = None
                presound = sa.WaveObject.from_wave_file(self.presound)
                activesound = presound.play()

                while activesound.is_playing():
                    time.sleep(0.1)

                del activesound

            #self.engine.say(msg)
            self.engine.save_to_file(msg,"temp.wav")
            self.engine.runAndWait()         
            
            finalsound = sa.WaveObject.from_wave_file("temp.wav")
            activesound = finalsound.play()

            while activesound.is_playing():
                time.sleep(0.1)

            del activesound
        except:
            traceback.print_exc()
            return

    def Close(self):
        pass
