import datetime
import traceback
import pytz
import json
import socket

class output:
    def __init__(self,config):
        self.config = config        
        self.json = True
        self.message = '%M'     
        self.timezone = 'UTC'
        
        if 'message' in config:
            self.message = config['message']

        if 'timezone' in config:
            self.timezone = config['timezone']

        self.tz = pytz.timezone(self.timezone)

    def Describe(self):
        desc = []
        desc.append({"name": "timezone", "type": "timezone"})
        desc.append({"name": "message", "type": "text","size": "large","desc":"The message to send","default": "%M"})
        desc.append({"name": "apikey", "type": "text","desc":"The SIGNL4 API Key."})
        desc.append({"name": "team", "type": "text","desc":"The ID of the team to transmit to"})
        return desc    

    def Initialise(self):        
        return True        

    def Escape(self,st):
        if self.json == True:
            return st.replace('"','\"').replace("\n",'\n')
        else:
            return st

    def Write(self,name,duration,offset,options=None): 
        
        #print(str(dir(self)))
        print("EVENT CONSOLE OUTPUT: " + self.host.Format(self,self.message,name,duration,offset,options)  )

    def Close(self):
        pass
