import datetime
import traceback
import requests
import copy
import pytz

class output:
    def __init__(self,config):                
        self.config = config
        self.url = config['url']        
        self.format = "%M"
        self.timezone = 'UTC'
        
        self.msg = {}
        self.msg['author.name'] = 'ARDI';
        self.msg['title'] = '%M'
        self.msg['description'] = '%M'        
        self.msg['footer.text'] = "%S"       

        if 'message' in config:
            for nm in config['message']:
                self.msg[nm] = config['message'][nm]
        
        if 'url' in config:
            self.url = config['url']

        if 'timezone' in config:
            self.timezone = config['timezone']

        self.tz = pytz.timezone(self.timezone)

    def Describe(self):
        desc = []
        desc.append({"name": "timezone", "type": "timezone"})
        desc.append({"name": "message", "type": "kvlist","desc":"The properties of the Discord Embed"})        
        desc.append({"name": "url", "type": "url","desc":"The Discord WebHook to send to"})
        return desc        

    def Initialise(self):            
        return True    

    def Supports(self,nm):        
        return False

    def Write(self,name,duration,offset,options=None): 
        try:                                     
            out = copy.deepcopy(self.msg)

            ob = {}
            for nm in self.msg:
                #print("Processing " + nm)
                bits = nm.split('.')
                if len(bits) > 1:
                    if bits[0] not in ob:
                        ob[bits[0]] = {}
                    ob[bits[0]][bits[1]] = self.host.Format(self,self.msg[nm],name,duration,offset,options) 
                else:
                    ob[nm] = self.host.Format(self,self.msg[nm],name,duration,offset,options)                 
                      
            content = {}
            content['author'] = {}
            content['author']['name'] = 'Optrix Notifications'
            content['embeds'] = [ob]            
            resp = requests.post(self.url,json=content)                 
                
        except:
            traceback.print_exc()
            return

    def Close(self):
        pass
