import datetime
import traceback
import pytz
import json
import re
import smtplib, ssl
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart

class output:
    def __init__(self,config):        
        self.config = config
        self.smtpserver = config['server']
        self.smtpport = 443
        if 'port' in config:
            self.smtpport = int(config['port'])

        self.fromaddr = config['from']
        self.password = config['password']
        self.toaddr = config['to']
        self.secure = False
        if self.smtpport > 100:
            self.secure = True

        self.subject = "ARDI Notification"
        if 'subject' in config:
            self.subject = config['subject']

        self.format = "<h3>%X</h3><p>%M</p>"

        if 'format' in config:
            self.format = config['format']

        if 'timezone' in config:
            self.timezone = config['timezone']

        if 'dateformat' in config:
            self.dateformat = config['dateformat']

    def Initialise(self):        
        return True    

    def Supports(self,nm):        
        return False

    def StripHTML(self,st):        
        return re.sub('<[^<]+?>', '', st)

    def Write(self,name,duration,offset,options=None): 
        try:            
            import smtplib, ssl
            from email.mime.text import MIMEText
            from email.mime.multipart import MIMEMultipart

            message = MIMEMultipart("alternative")
            sub = self.host.Format(self,self.subject,name,duration,offset,options)            
            message["Subject"] = sub
            message["From"] = self.fromaddr
            message["To"] = self.toaddr

            # Create the plain-text and HTML version of your message
            html = self.host.Format(self,self.format,name,duration,offset,options).replace("%X",sub)
            text = self.StripHTML(name)

            # Turn these into plain/html MIMEText objects
            part1 = MIMEText(text, "plain")
            part2 = MIMEText(html, "html")

            # Add HTML/plain-text parts to MIMEMultipart message
            # The email client will try to render the last part first
            message.attach(part1)
            message.attach(part2)

            #print(str(html))
            #return

            # Create secure connection with server and send email
            if self.secure == True:
                context = ssl.create_default_context()
                with smtplib.SMTP_SSL(self.smtpserver, self.smtpport, context=context) as server:
                    server.login(self.fromaddr, self.password)
                    server.sendmail(
                        self.fromaddr, self.toaddr, message.as_string()
                    )          
            else:
                with smtplib.SMTP(self.smtpserver, self.smtpport) as server:
                    server.login(self.fromaddr, self.password)
                    server.sendmail(
                        self.fromaddr, self.toaddr, message.as_string()
                    )  
                
        except:
            traceback.print_exc()
            return

    def Close(self):
        pass
