import datetime
import traceback
import pytz

class output:
    def __init__(self,config):        
        self.config = config
        self.filename = config['filename']
        self.timezone = 'UTC'
        if 'timezone' in config:
            self.timezone = config['timezone']
        self.format = "%S\t%E\t%M"
        if 'format' in config:
            self.format = config['format']
        self.dateformat = "%Y-%m-%d %H:%M:%S"
        if 'dateformat' in config:
            self.dateformat = config['dateformat']

        self.tz = pytz.timezone(self.timezone)

    def Initialise(self):
        #print("Truncating Log")
        self.file = open(self.filename,'a+')
        self.file.close()
        self.file = None
        return True

    def Write(self,name,duration,offset,options=None):        
        #print("Writing Log!")
        ln = self.host.Format(self,self.format,name,duration,offset,options)                        

        self.file = open(self.filename,'a+')
        try:
            self.file.write(ln + "\n")
        except:
            traceback.print_exc()

        self.file.flush()
        self.file.close()
        self.file = None

    def Close(self):
        if self.file is not None:            
            self.file.close()
