import datetime
import traceback
import pytz
import json


class output:
    def __init__(self,config):
        self.config = config
        self.server = config['host']
        self.path = "events"
        self.json = True
        self.message = '{"message": "%M","start": "%S", "end": "%E"}'
        self.timezone = 'UTC'

        if 'path' in config:
            self.path = config['path']
        if 'port' in config:
            self.port = config['port']           
        else:
            self.port = 1883

        if 'timezone' in config:
            self.timezone = config['timezone']

        if 'message' in config:
            self.message = config['message']
            if self.message[0] != '{' and self.message[0] != '[':
                self.json = False

        self.connection = None

    def Initialise(self):

        try:
            import paho.mqtt.client as mqtt
        except:
            print("'paho.mqtt' Python Module Must Be Installed")
            return False

        try:
            self.connection = mqtt.Client(client_id=self.name,clean_session=True)            
            self.connection.connect(host=self.server,port=self.port)
        except:
            traceback.print_exc()
            return False

        return True    

    def Supports(self,nm):
        if nm == 'hierarchy':
            return True
        return False

    def Escape(self,st):
        if self.json == True:
            return st.replace('"','\"').replace("\n",'\n')
        else:
            return st

    def Write(self,name,duration,offset,options=None): 
        try:
            ln = self.host.Format(self,self.message,name,duration,offset,options)                               
        except:
            return

        try:                        
            self.connection.publish(self.path,ln)
        except:
            traceback.print_exc()

    def Close(self):
        try:
            self.connection.close()
        except:
            pass
