import datetime
import traceback
import pytz

def SanitiseMySQL(tx):
    if not isinstance(tx,float) or isinstance(tx,int):
        return "'" + str(tx).replace("'","\'") + "'"

    return str(tx)

class output:
    def __init__(self,config):
        self.config = config        
        self.timezone = 'UTC'
        self.username = config['user']
        self.password = config['password']
        self.database = config['database']
        if 'host' in config:
            self.server = config['host']
        if 'server' in config:
            self.server = config['server']
        self.connection = None

        self.sql = "INSERT INTO events (start,end,message) VALUES (%S,%E,%M)"

        if 'timezone' in config:
            self.timezone = config['timezone']
        self.format = "%S\t%E\t%M"
        if 'sql' in config:
            self.sql = config['sql']
        self.dateformat = "%Y-%m-%d %H:%M:%S"        

        self.tz = pytz.timezone(self.timezone)

    def Initialise(self):
        try:
            import mysql.connector
        except:
            print("'mysql.connector' Python Module Must Be Installed")
            return False

        try:
            self.connection = mysql.connector.connect(user=self.username,password=self.password,database=self.database,host=self.server)
        except:
            traceback.print_exc()
            return False

    def Write(self,name,duration,offset,options=None):        

        ln = self.host.Format(self,self.sql,name,duration,offset,options,sanitise=SanitiseMySQL)
        

        cursor = self.connection.cursor()
        cursor.execute(ln)
        self.connection.commit()
        cursor.close()

    def Close(self):
        self.connection.close()
