import datetime
import traceback
import pytz
import json
import socket
import requests

class output:
    def __init__(self,config):
        self.config = config        
        self.json = True
        self.message = '%M'
        self.timezone = 'UTC'
               
        if 'timezone' in config:
            self.timezone = config['timezone']

        if 'message' in config:
            self.message = config['message']                    
        
        #Load Specific Settings
        apikey = ""
        if 'apikey' in config:
            apikey = config['apikey']

        self.team = ""
        if 'team' in config:
            self.team = config['team']

        self.headers = {}
        self.headers["x-s4-api-key"] = apikey
        self.headers['Content-type'] = 'application/json'
        self.title = None
        if 'title' in config:
            self.title = config['title']

    def Describe(self):
        desc = []
        desc.append({"name": "timezone", "type": "timezone"})
        desc.append({"name": "message", "type": "text","size": "large","desc":"The message to send","default": "%M"})
        desc.append({"name": "apikey", "type": "text","desc":"The SIGNL4 API Key."})
        desc.append({"name": "team", "type": "text","desc":"The ID of the team to transmit to"})
        return desc    

    def Initialise(self):        
        return True        

    def Escape(self,st):
        if self.json == True:
            return st.replace('"','\"').replace("\n",'\n')
        else:
            return st

    def Write(self,name,duration,offset,options=None): 
        
        try:
            ln = self.host.Format(self,self.message,name,duration,offset,options)                                 
        except:
            return

        title = name
        try:
            title = self.host.Format(self,self.title,name,duration,offset,options)                                 
        except:
            return

        try:            
            data = {}
            data['text'] = ln
            data['title'] = self.Escape(title)
            data['teamId'] = self.team
            data['externalId'] = data['title']

            #print(str(data))
            #print(str(self.headers))
            resp = requests.post("https://connect.signl4.com/api/v2/alerts",data=json.dumps(data),headers=self.headers)
            dta = resp.json()

            try:
                idno = dta['id']
            except:
                print(str(dta))
                print("Notification Unsuccessful")
        except:
            traceback.print_exc()

    def Close(self):
        pass
