import datetime
import traceback
import requests
import copy
import pytz
import json

class output:
    def __init__(self,config):                
        self.config = config
        self.url = config['url']        
        self.format = "%M"
        self.timezone = 'UTC'

        self.message = "%M"
        if 'message' in config:
            self.message = config['message']
        
        self.layout = '[{"type": "section","text": {"type": "mrkdwn","text": "%CONTENT%"}},{"type": "divider"}]'

        if 'layout' in config:            
            self.layout = config['layout']
        
        if 'url' in config:
            self.url = config['url']

        if 'timezone' in config:
            self.timezone = config['timezone']

        self.tz = pytz.timezone(self.timezone)

    def Describe(self):
        desc = []
        desc.append({"name": "timezone", "type": "timezone"})
        desc.append({"name": "message", "type": "kvlist","desc":"The properties of the Discord Embed"})        
        desc.append({"name": "url", "type": "url","desc":"The Discord WebHook to send to"})
        return desc        

    def Initialise(self):            
        return True    

    def Supports(self,nm):        
        return False

    def Write(self,name,duration,offset,options=None): 
        try:                                                 
  
            content = {}            
            final = self.layout.replace("%CONTENT%",self.message)            
            content['blocks'] = json.loads(self.host.Format(self,final,name,duration,offset,options))      
            headers = {}
            headers['Content-Type'] = 'application/json'
            resp = requests.post(self.url,json=content,headers=headers)                 
                
        except:
            traceback.print_exc()
            return

    def Close(self):
        pass
