import datetime
import traceback
import pytz

def SanitisePGSQL(tx):
    if not isinstance(tx,float) or isinstance(tx,int):
        return "'" + str(tx).replace("'","\'") + "'"

class output:
    def __init__(self,config):
        self.config = config        
        self.timezone = 'UTC'
        self.username = config['user']
        self.password = config['password']
        self.database = config['database']
        self.account = config['account']
        self.warehouse = config['warehouse']
        self.schema = config['schema']        
        self.connection = None

        self.sql = "INSERT INTO events (start,end,message) VALUES (%S,%E,%M)"

        if 'timezone' in config:
            self.timezone = config['timezone']
        self.format = "%S\t%E\t%M"
        if 'sql' in config:
            self.sql = config['sql']
        self.dateformat = "%Y-%m-%d %H:%M:%S"        

        self.tz = pytz.timezone(self.timezone)

    def Initialise(self):
        try:
            import snowflake.connector
            from snowflake.connector import DictCursor
        except:
            print("'snowflake.connector' Python Module Must Be Installed")
            return False

        try:
            self.connection = snowflake.connector.connect(
                user = self.username,
                password = self.password,
                account = self.account,
                warehouse=self.warehouse,
                database=self.database,
                schema=self.schema,
                session_parameters = {
            })
        except:
            traceback.print_exc()
            return False

    def Write(self,name,duration,offset,options=None):        

        ln = self.sql        
        ln = self.host.Format(self,self.sql,name,duration,offset,options,sanitise=SanitisePGSQL)

        cursor = self.connection.cursor()
        cursor.execute(ln)
        self.connection.commit()
        cursor.close()

    def Close(self):
        self.connection.close()
