import datetime
import traceback
import pytz
import json
import socket

class output:
    def __init__(self,config):
        self.config = config
        self.host = config['host']        
        self.json = True
        self.message = '{"message": "%M","start": "%S", "end": "%E"}'
        self.timezone = 'UTC'
       
        if 'port' in config:
            self.port = config['port']           
        else:
            self.port = 1883
        if 'timezone' in config:
            self.timezone = config['timezone']

        if 'message' in config:
            self.message = config['message']
            if self.message[0] != '{' and self.message[0] != '[':
                self.json = False

        self.client = None
        self.connection = None
        self.addressport = (self.host, self.port)        

    def Initialise(self):
        try:
            self.client = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)            
        except:
            traceback.print_exc()
            return False

        return True        

    def Escape(self,st):
        if self.json == True:
            return st.replace('"','\"').replace("\n",'\n')
        else:
            return st

    def Write(self,name,duration,offset,options=None): 
        try:
            ln = self.message

            en = datetime.datetime.now() - datetime.timedelta(seconds=offset)
            st = en - datetime.timedelta(seconds=duration)
        
            st = st.astimezone(self.tz)
            en = en.astimezone(self.tz)

            st = st.strftime(self.dateformat)
            en = en.strftime(self.dateformat)

            du = str(duration)

            ln = ln.replace("%S",st)
            ln = ln.replace("%E",en)
            ln = ln.replace("%D",du)
            ln = ln.replace("%M",self.Escape(name))            
                
        except:
            return

        try:
            self.client.sendto(ln.encode(), self.addressport)
        except:
            traceback.print_exc()

    def Close(self):
        self.connection.close()
