import datetime
import traceback
import pytz
import json
import requests

class output:
    def __init__(self,config):
        self.config = config        
        self.json = True
        self.message = '[ { "type": "ColumnSet","columns": [ { "type": "Column", "width": 1, "items": [ { "type": "Image", "url": "https://ardi.com.au/downloads/icons/teams/%Xblock.png", "size": "Medium", "altText": "Example image" } ] }, { "type": "Column", "width": 5, "items": [ { "type": "TextBlock", "text": "__content__", "wrap": true, "fontType": "Default","size": "Medium" }, { "type": "TextBlock",  "text": "%S", "wrap": true } ] } ] } ]'
        self.timezone = 'UTC'
        self.content = "%M"
               
        if 'timezone' in config:
            self.timezone = config['timezone']

        if 'message' in config:
            self.message = config['message']     
            
        if 'content' in config:
            self.content = config['content']
        
        #Load Specific Settings
        url = ""
        if 'url' in config:
            url = config['url']

        self.url = url
        self.tz = pytz.timezone(self.timezone)
        self.dateformat = "%Y-%m-%d %H:%M:%S"

        self.headers = {}
        self.headers['Content-type'] = 'application/json'

    def Describe(self):
        desc = []
        desc.append({"name": "timezone", "type": "timezone"})
        desc.append({"name": "message", "type": "text","size": "large","desc":"The full JSON of the message to be sent (overrides Content)."})
        desc.append({"name": "content", "type": "text","size": "large","desc":"The text of the message to be sent.","default": "%M"})
        desc.append({"name": "url", "type": "url","desc":"The Teams WebHook to send to"})
        return desc        

    def Initialise(self):        
        return True        

    def Escape(self,st):
        if self.json == True:
            return st.replace('"','\"').replace("\n",'\n')
        else:
            return st

    def Write(self,name,duration,offset,options=None): 
                
        try:
            ln = self.message
            ln = ln.replace("__content__",self.content)
            ln = self.host.Format(self,ln,name,duration,offset,options)            
            
            style = 'basic'
            if options is not None:
                if 'style' in options:
                    style = options['style']
                    
            ln = ln.replace('%X',style)
                
        except:
            print("Teams Notification Processing Failed")
            return

        try:            
            data = {}
            
            data['type'] = 'message'            
            msg = {}
            msg['contentType'] = "application/vnd.microsoft.card.adaptive"
            msg['contentUrl'] = ''

            content = {}
            content['$schema'] = "http://apativecards.io/schemas/adaptive-card.json"
            content['type'] = 'AdaptiveCard'
            content['version'] = '1.4'

            if self.message[0] == '[':
                content['body'] = json.loads(ln)
            else:
                body = {}
                body['type'] = 'TextBlock'
                body['text'] = ln

                content['body'] = body

            msg['content'] = content

            data['attachments'] = [msg]
            
            try:                
                resp = requests.post(self.url,data=json.dumps(data),headers=self.headers)                
                if resp.text != "1":
                    print("Teams Notification Failed (Server Side)")
                    return False
            except:                
                print("Teams Notification Failed (Server Unavailable)")         
                return False
        except:
            print("Teams Notification Failed")
            return False

        return True

    def Close(self):
        pass
