import datetime
import traceback
import twilio

from twilio.rest import Client

class output:
    def __init__(self,config):                
        self.config = config
        self.sid = ""
        self.token = ""
        self.format = "%M"
        self.ccode = "61"

        if 'sid' in config:
            self.sid = config['sid']
        if 'token' in config:
            self.token = config['token']
        if 'format' in config:
            self.format = config['format']
        if 'ccode' in config:
            self.ccode = config['ccode']

        self.fromnumber = None
        try:
            self.fromnumber = config['from']
        except:
            self.messagesource = config['source']

        self.tonumber = config['to']


    def Initialise(self):            
        return True    

    def Supports(self,nm):        
        return False

    def FormatNumber(self,num):
        if num[0] != "+":
            if num[0] == "0":
                num = num[1:]
            num = "+" + str(self.ccode) + str(num)
        return num

    def Write(self,name,duration,offset,options=None): 
        try:                         
            client = Client(self.sid, self.token)

            msg = self.host.Format(self,self.format,name,duration,offset,options)            
            #print("Sending Message: " + msg + " to " + self.FormatNumber(self.tonumber))
            message = client.messages.create(
                                 body=msg,
                                 from_="whatsapp:" + self.FormatNumber(self.fromnumber),
                                 to="whatsapp:" + self.FormatNumber(self.tonumber)
                             )     
                             
            #print(str(message.id))
                
        except:
            traceback.print_exc()
            return

    def Close(self):
        pass
