import datetime
import traceback
import socket

class output:
    def __init__(self,config):
        self.config = config
        if 'host' in config:
            self.server = config['host']
        else:
            self.server = "127.0.0.1"        
        self.port = config['port']     
        self.client = None
        self.connection = None
        self.addressport   = (self.server, self.port)

    def Initialise(self):
        try:
            self.client = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)            
        except:
            traceback.print_exc()
            return False

        return True    

    def Set(self,name,value,options=None):        
        try:
            self.client.sendto((name +"=" + str(value)).encode(), self.addressport)
        except:
            traceback.print_exc()

    def Close(self):
        pass
