import datetime
import traceback
import socket
import json

class output:
    def __init__(self,config):
        self.config = config
        if 'host' in config:
            self.host = config['host']
        else:
            self.host = "127.0.0.1"        
        self.port = config['port']     
        self.client = None
        self.connection = None
        self.addressport   = (self.host, self.port)

    def Initialise(self):
        try:
            self.client = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)            
        except:
            traceback.print_exc()
            return False

        return True    

    def Set(self,name,value,options=None):        
        try:
            message = {}
            message["name"] = name
            message["value"] = value

            if options is not None:
                if isinstance(options,list):
                    for n in options:
                        message[n] = 1
                else:
                    for n in options:
                        message[n] = str(options[n])

            msg = json.dumps(message)            
            self.client.sendto(msg.encode(), self.addressport)
        except:
            traceback.print_exc()

    def Close(self):
        pass
