import datetime
import traceback

try:
    from psycopg2.extensions import adapt
except:
    pass

class output:
    def __init__(self,config):
        self.config = config
        self.username = config['user']
        self.password = config['password']
        self.database = config['database']
        self.table = config['table']
        self.label = config['name']
        self.value = config['value']
        self.time = None
        if 'time' in config:
            self.time = config['time']
        self.server = config['host']

        self.bucketsize = 0
        if 'bucket' in config:
            self.bucketsize = config['bucket']

        self.connection = None

    def Initialise(self):
        try:
            import psycopg2            
        except:
            print("'psycopg2' Python Module Must Be Installed")
            return False

        try:
            self.connection = psycopg2.connect(user=self.username,password=self.password,database=self.database,host=self.server)
        except:
            traceback.print_exc()
            return False

        return True    

    def Set(self,name,value,options=None):        
        try:
            cursor = self.connection.cursor()

            if self.time is not None:
                fields = [self.time,self.label,self.value]
            else:
                fields = [self.name,self.value]

            if isinstance(value,str):
                value = adapt(value).getquoted().decode('ascii')

            sql = "INSERT INTO " + self.table + " (" + ",".join(fields) + ") VALUES ("
            if self.time is not None:
                if self.bucketsize != 0:
                    sql += "to_timestamp( round( ( extract ('epoch' from NOW()) ) / " + str(self.bucketsize) + " ) * " + str(self.bucketsize) + " ),"
                else:
                    sql += "NOW(),"
            sql +=  adapt(name).getquoted().decode('ascii') + "," + str(value) + " ON CONFLICT (id) DO UPDATE SET " + self.value + "=" + str(value)

            cursor.execute(sql)
            self.connection.commit()
            cursor.close()
        except:
            traceback.print_exc()

    def Close(self):
        self.connection.close()
