import datetime
import traceback

class output:
    def __init__(self,config):
        self.config = config
        self.server = config['host']
        self.port = config['port']           
        self.connection = None

    def Initialise(self):
        try:
            import redis
        except:
            print("'redis' Python Module Must Be Installed")
            return False
        try:
            self.connection = redis.Redis(host=self.server,port=self.port)
            self.connection.ping()
        except:
            traceback.print_exc()
            return False

        return True    

    def Set(self,name,value,options=None):        
        try:
            self.connection.set(name,value)
        except:
            traceback.print_exc()

    def Close(self):
        self.connection.close()
