import datetime
import traceback

class output:
    def __init__(self,config):
        self.config = config
        self.username = config['user']
        self.password = config['password']
        self.database = config['database']
        self.table = config['table']
        self.label = config['name']
        self.value = config['value']
        self.account = config['account']
        self.warehouse = config['warehouse']
        self.schema = config['schema']
        self.time = None
        if 'time' in config:
            self.time = config['time']        
        self.connection = None

    def Initialise(self):
        try:
            import snowflake.connector
            from snowflake.connector import DictCursor
        except:
            print("'snowflake.connector' Python Module Must Be Installed")
            return False

        try:
            self.connection = snowflake.connector.connect(
                user = self.username,
                password = self.password,
                account = self.account,
                warehouse=self.warehouse,
                database=self.database,
                schema=self.schema,
                session_parameters = {
            })
        except:
            traceback.print_exc()
            return False

        return True    

    def Set(self,name,value,options=None):        
        try:
            cursor = self.connection.cursor()

            if self.time is not None:
                fields = [self.time,self.label,self.value]
            else:
                fields = [self.name,self.value]

            sql = "INSERT INTO " + self.table + " (" + ",".join(fields) + ") VALUES ("
            if self.time is not None:
                sql += "NOW(),"
            sql += "'" + name + "'," + str(value) + ") ON DUPLICATE KEY UPDATE " + self.value + "=" + str(value)            

            cursor.execute(sql)
            self.connection.commit()
            cursor.close()
        except:
            traceback.print_exc()

    def Close(self):
        self.connection.close()
