import datetime
import traceback

class output:
    def __init__(self,config):
        self.config = config
        self.filename = config['filename']
        self.delimiter = '='        
        self.values = {}
        if 'delimiter' in config:
            self.delimiter = config['delimiter']

    def Initialise(self):
        try:
            self.file = open(self.filename,'r')
            ln = self.file.readline()
            while ln != "":
                bits = ln.split(self.delimiter)
                if len(bits) > 1:
                    self.values[bits[0]] = bits[1]
                ln = self.file.readline()

            self.file.close()
        except:
            pass

        return True

    def Rewrite(self):
        self.file = open(self.filename,'w')
        for k,v in self.values.items():
            self.file.write(k + self.delimiter + str(v) + "\n")

        self.file.flush()
        self.file.close()        

    def Set(self,name,value,options=None):                
        try:
            self.values[name] = value

            if options is not None:
                if 'batched' in options:
                    print("Ignoring Write - Part of a Batch")
                    return

            self.Rewrite()
        except:
            traceback.print_exc()

    def Close(self):
        try:
            self.file.flush()
        except:
            pass
        try:
            self.file.close()
        except:
            pass
