import datetime
import traceback

class output:
    def __init__(self,config):
        self.config = config
        self.host = config['host']
        self.port = config['port']
        self.prefix = ""
        if 'prefix' in config:
            self.prefix = config['prefix']

    def Initialise(self):
        try:
            from pymemcache.client import base
        except:
            return False

        self.connection = base.Client((self.host,int(self.port)))
        return True

    def Set(self,name,value,options=None):        
        try:
            self.connection.set(self.prefix + name.replace(" ","_"),value)
        except:
            traceback.print_exc()

    def Close(self):
        pass
