import datetime
import traceback
import json 
import threading

available = False

#NOTE: This is a minimal example, and currently only supports INTEGER types and HOLDING REGISTERS

from pymodbus.server import StartTcpServer
from pymodbus.device import ModbusDeviceIdentification
from pymodbus.datastore import ModbusSequentialDataBlock, ModbusSparseDataBlock
from pymodbus.datastore import ModbusSlaveContext, ModbusServerContext

class output:
    def __init__(self,config):
        self.config = config    
               
        self.port = 502
        self.server = None
        self.points = 1000
        if 'points' in config:
            self.points = config['points']
        if 'port' in config:
            self.port = config['port']   

        self.LoadMapping(config['mapping'])
            
        self.analogueblock = ModbusSequentialDataBlock(0,[0]*self.hrsize)
        
        self.store = ModbusSlaveContext(
            di=ModbusSequentialDataBlock(0,[0] * self.disize),
            co=ModbusSequentialDataBlock(0,[0] * self.csize),
            hr=self.analogueblock,
            ir=ModbusSequentialDataBlock(0,[0] * self.irsize)
            )

        self.context = ModbusServerContext(slaves=self.store,single=True)

    def LoadMapping(self,map):
        self.map = map
        self.hrsize = 1
        self.irsize = 1
        self.csize = 1
        self.disize = 1
        for m,v in self.map.items():
            if v['register'] == "holding":
                v['registerno'] = 3
                maxpos = v['address']
                if self.hrsize < maxpos+1:
                    self.hrsize = maxpos + 1            


    def ThreadFunc(self):
        identity = ModbusDeviceIdentification()
        identity.VendorName = 'ARDI'
        identity.ProductCode = 'OX'
        identity.VendorUrl = 'http://github.com/riptideio/pymodbus/'
        identity.ProductName = self.name
        identity.ModelName = self.name
        identity.MajorMinorRevision = '1.5'

        self.active = True
        self.server = StartTcpServer(context=self.context, identity=identity, address=("localhost", self.port))

    def Initialise(self):        
        try:            
            
            self.mainthread = threading.Thread(target=self.ThreadFunc,daemon=True)
            self.mainthread.start()            

        except:
            traceback.print_exc()
            return False
        return True

    def GetOffset(self,name):
        pid = self.idpersist.PointID(name)
        if pid >= self.points:
            return -1
        return pid

    def Supports(self,nm):        
        return False

    def Set(self,name,value,options=None):
        if name not in self.map:
            return             

        itm = self.map[name]
        val = int(value)

        if 'min' in itm:
            mn = float(itm['min'])
            mx = float(itm['max'])
            val = float(val) - mn / (mx - mn)
            if val > 1:
                val = 1
            if val < 0:
                val = 0
            val *= int(65535)

        try:            
            self.context[0].setValues(itm['registerno'],itm['address'],[val])
        except:
            traceback.print_exc()

    def Close(self):
        print("Shutting Down Modbus Server " + str(self.server))
        try:
            self.server.shutdown()
        except:
            traceback.print_exc()        
