import datetime
import traceback
import mysql.connector

class output:
    def __init__(self,config):
        self.config = config  
        self.values = {}

    def Initialise(self):        
        return True    

    def Set(self,name,value,options=None):        
        self.values[name] = value

    def Supports(self,name):
        if name == "html":
            return "api"
        return False

    def HTML(self,uri,response):
        url = uri.decode()

        if url[0] == '/':
            url = url[1:]
        bits = url.split('/')

        #print(str(bits))
        if len(bits) == 1:
            mode = "json"
        else:            
            mode = bits[1]

        if mode == "txt" or mode == "txth":
            lines = []
            if mode == "txth":
                lines.append("Name\tValue")
            for k,v in self.values.items():
                lines.append(k + "\t" + str(v))
            response.responseHeaders.addRawHeader('Content-Type', 'text/plain')
            return "\n".join(lines)


        if mode == "csv" or mode == "csvh":
            lines = []
            if mode == "csvh":
                lines.append("Name,Value")
            for k,v in self.values.items():
                lines.append(k + "," + str(v))
            response.responseHeaders.addRawHeader('Content-Type', 'text/plain')
            return "\n".join(lines)

        if mode == "xml":
            lines = []
            lines.append("<values>")
            for k,v in self.values.items():
                cn = self.CleanName(k)
                lines.append("<" + cn + ">" + str(v) + "</" + cn + ">")
            lines.append("</values>")
            response.responseHeaders.addRawHeader('Content-Type', 'text/xml')
            return "\n".join(lines)

        if mode == "xml2":
            lines = []
            lines.append("<values>")
            for k,v in self.values.items():                
                lines.append('<v name="' + k.replace('"','&quot;') + '">' + str(v).replace('"','&quot;') + '</v>')
            lines.append("</values>")
            response.responseHeaders.addRawHeader('Content-Type', 'text/xml')
            return "\n".join(lines)

        if mode == "xml3":
            lines = []
            lines.append("<values>")
            for k,v in self.values.items():
                lines.append('<v name="' + k.replace('"','&quot;') + '" value="' + str(v).replace('"','&quot;') + '"/>')
            lines.append("</values>")
            response.responseHeaders.addRawHeader('Content-Type', 'text/xml')
            return "\n".join(lines)

        if mode == "jsonh":
            lines = []
            lines.append("{")
            indx = -1
            ttl = len(self.values)-1
            for k,v in self.values.items():
                indx += 1
                vx = str(v)
                if not vx.isdigit():
                    vx = '"' + vx + '"'
                if indx == ttl:
                    lines.append('{"name":' + k + ',"value":' + vx + '}')
                else:
                    lines.append('["name":' + k + ',"value":' + vx + '},')
            lines.append("}")
            response.responseHeaders.addRawHeader('Content-Type', 'application/json')
            return "\n".join(lines)
        
        lines = []
        lines.append("{")
        indx = -1
        ttl = len(self.values)-1
        for k,v in self.values.items():
            indx += 1
            vx = str(v)
            if not vx.isdigit():
                vx = '"' + vx + '"'
            if indx == ttl:
                lines.append("[" + k + "," + vx + "]")
            else:
                lines.append("[" + k + "," + vx + "],")
        lines.append("}")
        response.responseHeaders.addRawHeader('Content-Type', 'application/json')
        return "\n".join(lines)

    def Close(self):
        pass
