#!/usr/bin/python3

import argparse
import platform
import shutil
import sys
#import pycurl
import os
from subprocess import call
import traceback
import xmltodict

def SetNSSM(nssmpath,drivername,property,value):
    cmd = "\"" + nssmpath + "\" set \"" + drivername + "\" " + property + " " + value
    call(cmd, shell=True)
    #print cmd

def WindowsInstaller(server):
    print("Installing Alert Manager for Windows...")
    pathtopython = "c:\\Python310\\python.exe"
    pathtotwisted = "c:\\Python310\\scripts\\twistd.exe"

    #fullpath = "\"" + pathtopython + "\" \"\"" + pathtotwisted + " " + "\"\" ardicon --inport=" + str(inport) + " --outport=" + str(outport) + " --server=" + server
    #pathtotwisted = pathtotwisted + "scripts\\twistd.exe"
    fullpath = "\"" + pathtopython + "\" --server=" + server + "\""
    
    try:
        pathtopython = os.getenv('ARDIPythonPath',"c:\\Python310\\python.exe")
        pathtotwisted = ""
        if pathtopython is None:
            pathtopython = "c:\\python310\\python.exe"
        bits = pathtopython.split('\\')
        for x in range(0,len(bits)-1):
            pathtotwisted += bits[x]
            pathtotwisted += "\\"
        

        fullpath = "\"" + pathtopython + "\" \"\"\"" + os.path.realpath(__file__).replace("alarminstaller","alarmmanager") + "\"\"\" " + server + ""
    except:
        traceback.print_exc()
        pass

    print("Installing Service @ " + pathtotwisted)
    
    is64 = False
    if platform.machine().endswith('64'):
        is64 = True

    basepath = os.path.dirname(os.path.dirname(os.path.dirname(os.path.realpath(__file__)))) + "\\Drivers"
    
    nssmpath = basepath
    if is64:
        nssmpath = nssmpath + "\\nssm\\win64"
    else:
        nssmpath = nssmpath + "\\nssm\\win32"

    nssmpath = nssmpath + "/nssm.exe"    
    print("Creating NSS Service using NSSM @ " + nssmpath)

    bits = server.split('/')
    srvname = bits[len(bits)-1]

    drivername = "ARDI Alert Manager for " + str(srvname)

    #Installing the base service...
    cmd = "\"" + nssmpath + "\" install \"" + drivername + "\" " + fullpath
    call(cmd, shell=True)
    #print "Running - " + cmd    

    basepath = os.path.dirname(os.path.realpath(__file__))

    #Get Logging Path
    loggingpath = os.path.dirname(os.path.dirname(__file__)) + "/logs"
    try:
        loggingpath = os.getenv('ARDILogPath',loggingpath)        
    except:
        pass

    #Redirection of I/O...
    SetNSSM(nssmpath,drivername,"AppDirectory",basepath)
    SetNSSM(nssmpath,drivername,"AppStderr",loggingpath + "/" + str(srvname) + "_alerts.log")
    SetNSSM(nssmpath,drivername,"AppStderrCreationDisposition","2")
    SetNSSM(nssmpath,drivername,"AppStderrShareMode","4")
    SetNSSM(nssmpath,drivername,"AppStdout",loggingpath + "/" + str(srvname) + "_alerts.log")
    SetNSSM(nssmpath,drivername,"AppStdoutCreationDisposition","2")    
    SetNSSM(nssmpath,drivername,"AppStdoutShareMode","4")
    SetNSSM(nssmpath,drivername,"AppRotateFiles","1")
    SetNSSM(nssmpath,drivername,"AppRotateBytes","1048576")

    #Prevent Windows Event-Style Terminations (Useless on Python apps)
    SetNSSM(nssmpath,drivername,"AppStopMethodSkip","6")    
    
    print("Starting NSS Service...")
    
    cmd = "\"" + nssmpath + "\" start \"" + drivername + "\""
    call(cmd, shell=True)
    #print "Running - " + cmd

def WindowsUninstaller(server):
    is64 = False
    if platform.machine().endswith('64'):
        is64 = True

    basepath = os.path.dirname(os.path.dirname(os.path.dirname(os.path.realpath(__file__)))) + "\\Drivers"
    
    nssmpath = basepath
    if is64:
        nssmpath = nssmpath + "\\nssm\\win64"
    else:
        nssmpath = nssmpath + "\\nssm\\win32"

    nssmpath = nssmpath + "/nssm.exe"

    bits = server.split('/')
    srvname = bits[len(bits)-1]

    drivername = "ARDI Alert Manager for " + str(srvname)

    cmd = "\"" + nssmpath + "\" stop \"" + drivername + "\""
    call(cmd, shell=True)

    cmd = "\"" + nssmpath + "\" remove \"" + drivername + "\" confirm"
    call(cmd, shell=True)

    
def LinuxInstaller(server):
    
    print("Installing Alert Manager for Linux...")

    bits = server.split('/')
    srvname = bits[len(bits)-1]
    
    basepath = '/opt/ardi/srv/alarmmanager'
    lxpath = basepath + "/linux"
    
    finalpath = "/etc/systemd/system/alarmmanager-" + str(srvname)+".service"
    logpath = "/var/log/ardi/alarmmanager-" + str(srvname) + ".log"
    scriptpath = os.path.dirname(__file__) + os.sep + "alarmmanager.py"

    #Get Python Location
    try:
        pathtopython = os.getenv('ARDIPythonPath',"python3")
    except:
        pass
    if pathtopython is None:
        pathtopython = "python3"    
    
    print("Creating Daemon Script...")
    file = open(lxpath + '/systemd.service','r')
    fl = file.read()
    file.close()
    st = str(fl)    
    st = st.replace("$SITE$",str(srvname))
    st = st.replace("$SERVER$",server)    
    st = st.replace("$LOGPATH$",logpath)
    st = st.replace("$PYTHON$",pathtopython)
    st = st.replace("$SCRIPT$",scriptpath)
    #finalpath = basepath + "/" + mode + "/" + driver + "/" + str(portno)    
    file = open(finalpath,'w')
    file.write(st)
    file.flush()
    file.close()    
    #print("Marking File as Executable...")
    #call("chmod gu+x " + finalpath, shell=True)
    
    #finalpath = finalpath + " " + str(portno)
    
    call("chmod gu+r " + finalpath,shell=True)
        
    cmd = "systemctl daemon-reload"
    call(cmd, shell=True)
    
    print("Creating Log Files...")
    
    call("touch " + logpath, shell=True)    
    call("chmod a+r " + logpath, shell=True)
        
    print("Starting Service...")

    call("systemctl start alarmmanager-" + str(srvname) , shell=True)
    call("systemctl enable alarmmanager-" + str(srvname) , shell=True)


def LinuxUninstaller(server):
    
    print("Removing Driver for Linux...")

    bits = server.split('/')
    srvname = bits[len(bits)-1]
    
    print("Shutting Down Driver")
    cmd = "systemctl stop alarmmanager-" + str(srvname)
    call(cmd, shell=True)
    cmd = "systemctl disable alarmmanager-" + str(srvname)
    call(cmd, shell=True)

    print("Removing Service Definition")
    #cmd = "rm /etc/init.d/ardi-" + str(portno)
    cmd = "rm /etc/systemd/system/alarmmanager-" + str(srvname) + ".service"
    call(cmd, shell=True)
    
    print("Removing From Boot")
    #cmd = "update-rc.d ardi-" + str(portno) + " remove"
    cmd = "systemctl daemon-reload"
    call(cmd, shell=True)  

parser = argparse.ArgumentParser(description="Manage ARDI Alert Managers")
parser.add_argument('server', help='The URL to the ARDI server')
parser.add_argument('action', help='\'install\' or \'remove\'')

args = parser.parse_args()
    
is_admin = False

import ctypes, os
try:
    is_admin = os.geteuid() == 0
except AttributeError:
    is_admin = ctypes.windll.shell32.IsUserAnAdmin() != 0
    
  
if is_admin == False:
    print("Error: This must be run as root/an Administrator")
    sys.exit(0)        

#Install driver as a service...
server = args.server

print("Installing " + str(server) + " Alarm Manager")

ActionName = "Installed"

if args.action == "install":
    if platform.system() == "Windows":
        WindowsInstaller(server)
        pass
    else:
        LinuxInstaller(server)
        pass    

if args.action == "remove":
    ActionName = "Removed"
    if platform.system() == "Windows":
        WindowsUninstaller(server)
        pass
    else:
        LinuxUninstaller(server)
        pass

print("ARDI Alert Manager Service " + ActionName)
