import alarmmanager
import socket

class Writer(alarmmanager.AlarmWriter):
    def Configuration(self,config):
        self.store = []
        self.outhost = "127.0.0.1"
        try:
            self.outport = config['port']
        except:
            self.outport = None
        try:
            self.outhost = config['server']
        except:
            self.outhost = "127.0.0.1"    
        
    def SendItem(self,dta):
        #print("Sending: " + str(dta))
        if dta.flags & 4:
            code = str(dta.asset) + ":-10:" + str(dta.id)
            value = dta.status
        else:
            code = str(dta.asset) + ":-1:" + str(dta.id)
            value = 0
            if dta.status is None:
                value = 1
            if dta.status == True:
                value = 1            
        self.store.append(code+"="+str(value)+"\r\n")

    def UpdateEnd(self):
        if len(self.store) == 0:
            return
        
        self.client = socket.socket(socket.AF_INET,socket.SOCK_STREAM)
        try:            
            self.client.connect((self.outhost,int(self.outport)))
            combined = ''.join(self.store)
            self.client.send(bytes(combined,'utf-8'))                    	
            self.client.close()
            self.store = []
            #print(str(combined))
        except:
            self.server.LogFailure(self.name + " Error - Unable to connect to Consolidator")
        
