import alarmmanager
import mysql.connector
import traceback

class Writer(alarmmanager.AlarmWriter):
    def Configuration(self,config):
        self.setone = []
        self.setzero = []
        self.secondaryqueries = []
        
        try:
            self.dbhost = config['host']
        except:
            self.dbhost = None

        if self.dbhost is None or self.dbhost == "":
            self.dbhost = "127.0.0.1"

        try:
            self.dbname = config['database']
        except:
            self.dbname = None

        try:
            self.dbuser = config['user']
        except:
            self.dbuser = None

        try:
            self.dbpwd = config['password']
        except:
            self.dbpwd = None

        self.mydb = None
        if self.dbhost is not None:
            self.mydb = mysql.connector.connect(
                host=self.dbhost,
                user=self.dbuser,
                password=self.dbpwd,
                database=self.dbname
            )

            #Erase all dynamic content....
            csr = self.mydb.cursor()
            csr.execute("TRUNCATE dynamicalerts")
            del csr
        
    def SendItem(self,dta):
        if dta.flags & 4:
            if dta.status == "":
                self.secondaryqueries.append("DELETE FROM dynamicalerts WHERE sourceid=" + str(dta.id) + " AND assetid=" + str(dta.asset))
            else:
                self.secondaryqueries.append("INSERT INTO dynamicalerts (sourceid,assetid,value) VALUES (" + str(dta.id) + "," + str(dta.asset) + ",'" + str(dta.status) + "') ON DUPLICATE KEY UPDATE value='" + str(dta.status) + "'")
            return
                                           
        if dta.status is None or dta.status == True:
            self.setone.append(str(dta.id))
        else:
            self.setzero.append(str(dta.id))

    def UpdateEnd(self):
        if self.mydb is None:
            return
        
        try:
            queries = []
            
            if len(self.setone) > 0:
                writing = []
                for s in self.setone:
                    writing.append(str(s))

                st = "UPDATE alerts SET state=1 WHERE id IN (" + ','.join(writing) + ")"
                queries.append(st)

            if len(self.setzero) > 0:
                writing = []
                for s in self.setzero:
                    writing.append(str(s))

                st = "UPDATE alerts SET state=0 WHERE id IN (" + ','.join(writing) + ")"
                queries.append(st)

            if len(self.secondaryqueries) > 0:
                for n in self.secondaryqueries:
                    queries.append(n)        

            #print(str(queries))

            if len(queries) > 0:
                loop = 0
                queries.append("COMMIT")
                while loop < 2:                
                    try:
                        csr = self.mydb.cursor()
                        for q in queries:
                            csr.execute(q)
                            #print(str(q))

                        self.setone = []
                        self.setzero = []
                        self.secondaryqueries = []
                        break
                    except:
                        traceback.print_exc()
                        print("Write Failure - Let's Try Again")
                        self.server.Log("MySQL Write Failure. Reconnecting.")
                        print("Connecting to " + self.dbhost + "," + self.dbuser + "," + self.dbpwd + "," + self.dbname)
                        self.mydb = mysql.connector.connect(
                            host=self.dbhost,
                            user=self.dbuser,
                            password=self.dbpwd,
                            database=self.dbname
                        )
                    loop = loop + 1
                
                if loop == 2:
                    self.server.Log("MySQL Write Failed!")
        except:
            traceback.print_exc()
            pass

