#!/usr/bin/ardipython

import argparse
import platform
import shutil
import sys
import requests
import os
from subprocess import call
import traceback
import xmltodict

def GetConsolidatorList(remotehost):    
    try:
        #buf = StringIO()
        
        url = 'http://' + remotehost + '/api/profiles';
        #print "Querying: " + url
        
        #c = pycurl.Curl()
        #c.setopt(c.URL, url)
        #try:
        #    c.setopt(c.WRITEDATA, buf)
        #except:
        #    c.setopt(c.WRITEFUNCTION, buf.write)
        #c.perform()
        #c.close()

        #print "Almost Done..."
        web = requests.get(url)
        s = web.text        

        #print s

        result = xmltodict.parse(s)

        try: 
            return [(int(result['profiles']['profile']['@in']),int(result['profiles']['profile']['@out']))]
        except:
            lst = []
            for drv in result['profiles']['profile']:
                lst.append((int(drv['@in']),int(drv['@out'])))
                            
            return lst
    except:
        print("Failed To Get ARDI Profile Details")
        #traceback.print_exc()
        return []
    
parser = argparse.ArgumentParser(description="Maintain ARDI Profile Set")
parser.add_argument('server',help='The URL of your ARDI instance')
parser.add_argument('mode',help='Choose between \'install\' and \'remove\'')

import ctypes, os
try:
    is_admin = os.geteuid() == 0
except AttributeError:
    is_admin = ctypes.windll.shell32.IsUserAnAdmin() != 0
    
if is_admin == False:
    print("Error: This must be run as root/an Administrator")
    sys.exit(0)  

args = parser.parse_args()
    
#Override
server=args.server
mode = args.mode

if ((mode != 'remove') and (mode != 'install')):
    print("Invalid Mode Selected")
    sys.exit(-1)

#Get Driver Information
drivers = GetConsolidatorList(server)

md = "";
if (mode == 'install'):
    md = "install"
if (mode == 'remove'):
    md = 'remove';

if (md == ""):
    print("Invalid Action Paramter")
    sys.exit(1)

#print str(drivers)

if len(drivers) == 0:
    drivers = [(5225,8079)]

for drv in drivers:
    try:
        if platform.system() == "Windows":
            
            pypath = os.getenv('ARDIPythonPath')
            if pypath is None:
                if os.name == "nt":
                    pypath = 'c:\python38\python.exe';
                else:
                    pypath = 'python3'
                            
            
            bpth = os.path.dirname(os.path.realpath(__file__))
            cmd = '"' + pypath + '" "' + bpth + '\\ardiconsol.py" ' + md + " " + str(drv[0]) + " " + str(drv[1]) + " " + server
            print(cmd)
            call(cmd, shell=True)
        else:
            cmd = "/opt/ardi/srv/consolidator/ardiconsol " + md + " " + str(drv[0]) + " " + str(drv[1]) + " " + server
            call(cmd, shell=True)
    except Exception as e:
        print('Could Not Update Profile/Consolidator - ' + str(e))

print("Process Complete")
    
