import sys
import random
import datetime
import math
from datetime import timedelta

from ardi.driver import histdriverbase

def fixdate(dt):
	ps = dt.find('.')
	if ps > -1:
		return dt[0:ps]
	return dt

class ardisimdriver:
    def __init__(self):
        self.path = ""
	
    def SetAddress(self, addr):
        self.path = addr
		
    def Connect(self):
        try:
                self.issues = []
                self.connected = True
                return True
        except:
                self.issues = ["Unexpected Failure"]
                return False		
		
    def Disconnect(self):
        self.con.close()
        pass
        
    def RunQuery(self, query):
        self.core.logger.info("Performing '" + query.function + "' query between " + str(query.sd) + " and " + str(query.ed) + " with " + str(query.grain) + " grain.") 								

        query.interpolates = True
        sd = query.sd
        ed = query.ed

        if sd == ed:
                for p in query.addresses:
                        val = round(random.random() * 100.0,2)
                        query.AddLine(p,sd,val)
                return query.Finish()

        diff = ed - sd

        secs = diff.seconds + (diff.days * (60*60*24))

        #print "Total Seconds..." + str(secs)

        count = 50
        grain = int(query.grain)
        if query.function == "min":
                query.grain = int(query.grain)
                if query.grain < 0:
                        query.grain = query.grain * 5                        
                else:
                        query.grain = int(math.ceil(query.grain / 5))
        if grain > 0:
                count = secs / int(grain)
        else:
                #print "Negative Grain."
                count = -int(grain)
                if count <= 1:	
                        count = 2;
                #print "Total Count: " + str(count)
                
        stepsize = secs / count
        step = timedelta(seconds=stepsize)

        for x in range(0,count):			
                for p in query.addresses:
                        val = round(random.random() * 100.0,2)
                        query.AddLine(p,sd,val)
                sd = sd + step
                                
        return query.Finish()
		            
class driverfactory:
    def createinstance(self):
        return ardisimdriver()
            
if __name__ == "__main__":
    sdf = driverfactory()
    base = histdriverbase.historian()
    base.start(sdf)
