import sys
import threading
import os
import time
import requests
import json
import csv
import traceback

from ardi.driver import drivercore, driverbase

class ardidriverdriver:
    def __init__(self):
        #Prepare all of the internal variables
        self.connected = False
        self.polling = True
        self.server = "127.0.0.1/s/default"
    
    def SetAddress(self, addr):
        self.connected = False
        self.server = addr
        if self.server[len(self.server)-1] == '/':
            self.server = self.server[0:len(self.server)-1]

    def Connect(self):

        #Verify that the server works
        try:
            resp = requests.get("http://" + self.server + "/api/driverstatus?format=json")
            if "consolidator" not in resp.text:
                self.core.logger.warning("Unexpected Remote Text")
                self.issues = ["Response was not valid"]
                return False
        except Exception as e:
            self.core.logger.warning("Unable to connect to ARDI Server - " + str(e))
            self.connected = False
            self.issues = ["Unable to connect to server"]
            return False
        
        self.connected = True
        self.issues = []
        return True
    
    def Disconnect(self):        
        self.connected = False
        
    def Optimise(self):
        pass

    def ObjectAttrs(self,obj):
        try:
            return vars(obj)
        except:
            pass

        try:
            slots = obj.__slots__
        except:
            return {}

        att = {}
        for name in slots:
            try:
                att[name] = getattr(obj,name)
            except:
                continue

        return att
        
    def Poll(self):

        #Fetch the current driver status from the API
        start_time = time.perf_counter()
        
        resp = requests.get("http://" + self.server + "/api/driverstatus?format=json")
        output = resp.json()

        end_time = time.perf_counter()

        ttime = end_time - start_time
        if ttime*2 > self.core.sampletime:
            self.core.sampletime = ttime * 2

        #print(str(output))

        consolidators = output['consolidator']
        if isinstance(consolidators, dict):
            consolidators = [consolidators]

        for con in consolidators:
            addr = "con_" + str(con['port'])
            val = 0
            if con['status'] == 'Online':
                val = 1
            self.core.NewData(addr,val)

        drivers = output['driver']
        if isinstance(drivers, dict):
            drivers = [drivers]

        for drv in drivers:
            addr = "driver_" + str(drv['port'])
            val = 0
            if drv['status'] == 'Online':
                val = 1
            self.core.NewData(addr,val)

        sources = output['source']
        if isinstance(sources, dict):
            sources = [sources]

        for src in sources:
            #print(str(src))
            addr = "source_" + str(src['id'])
            val = 0
            if src['status'] == 'Online':
                val = 2
            if src['status'] == 'Issues':
                val = 1
            self.core.NewData(addr,val)

class driverfactory:
    def createinstance(self):
        return ardidriverdriver()
            
if __name__ == "__main__":
    sdf = driverfactory()
    base = driverbase.ardidriver()
    base.start(sdf)
    
