<?php
function GetHistoryStringToUTC($dt,$timezone)
{
	$tz = new DateTimeZone($timezone);
	$dt = new DateTimeImmutable($dt,$tz);
	$dt = $dt->setTimezone(new DateTimeZone('UTC'));
	return $dt->format("Y-m-d H:i:s");
}

function GetHistoryStringToLocal($dt,$timezone)
{
	$tz = new DateTimeZone($timezone);
	$dt = new DateTimeImmutable($dt,new DateTimeZone('UTC'));
	$dt = $dt->setTimezone($tz);
	return $dt->format("Y-m-d H:i:s");
}

function fn_gethistory_tm($aql)
{
	$data = $aql->Consume(2);		
	
	$dateend = "";//new DateTime("now", new DateTimeZone("UTC"))->format("Y-m-d h:i:s");
	$datestart = "";//new DateTime("- 6 hours",new DateTimeZone("UTC"))->format("Y-m-d h:i:s");
	//print($dateend);
	$grain = -100;
	$method = "interp";
	$context = 1;
	$timezone = "UTC";	
	
	//print_r($data);
	
	global $installfolder;
	require_once($installfolder.'/include/historian.php');
	
	if (isset($data[0]->value['tz']))
	{
		$timezone = $data[0]->value['tz'];
	}
	
	if ($timezone != "UTC")
	{
		if ($timezone == "local")
		{
			global $sitefolder;
			if (file_exists($sitefolder.'/config/settings.ini'))
			{				
				$inx = parse_ini_file($sitefolder.'/config/settings.ini',true);
				$timezone = $inx['server']['tz'];
			}
			else
			{			
				$timezone = date_default_timezone_get();
			}
		}		
	}
	
	foreach($data[0]->value as $k => $v)
	{
		
		if ($k == 'start') 
		{
			//echo $v.'<br/>';
			$datestart = $v;
			if ($timezone != "UTC")
			{
				$datestart = GetHistoryStringToUTC($datestart,$timezone);
			}
		}
		if ($k == 'end') 
		{
			//echo $v.'<br/>';
			$dateend = $v;
			if ($timezone != "UTC")
			{
				$dateend = GetHistoryStringToUTC($dateend,$timezone);
			}
		}
		if ($k == 'range')
		{
			$bits = explode(' from ',$v);
			$dateend = date("Y-m-d H:i:s");		
			
			$special = false;			
			
			if ($special == false)
			{
				$range = DateInterval::createFromDateString($bits[0]);			
				$datestart = DateTime::createFromFormat("Y-m-d H:i:s",$dateend,new DateTimeZone('UTC'));
				$datestart = $datestart->sub($range);
				$datestart = $datestart->format("Y-m-d H:i:s");
				if (count($bits) > 1)
				{
					$end = DateTime::createFromFormat("Y-m-d H:i:s",$dateend,new DateTimeZone('UTC'));
					$start = DateTime::createFromFormat("Y-m-d H:i:s",$datestart,new DateTimeZone('UTC'));
					$xx = explode(':',$bits[1]);
					if (count($xx) == 2)
						$bits[1] .= ":00";
					$oftime = $end->format("Y-m-d")." ".$bits[1];
					
					$offset = DateTime::createFromFormat("Y-m-d H:i:s",$oftime,new DateTimeZone('UTC'));				
					$diff = $offset->diff($end);				
					$current = DateTime::createFromFormat("Y-m-d H:i:s",$dateend,new DateTimeZone('UTC'));				
					if ($offset > $current)
					{
						$dateend = $dateend->sub(DateInterval::createFromDateString("1 day"));
						$datestart = $datestart->sub(DateInterval::createFromDateString("1 day"));					
					}
					$datestart = $start->sub($diff)->format("Y-m-d H:i:s");
					$dateend = $end->sub($diff)->format("Y-m-d H:i:s");
				}		
			}			
		}
		if ($k == 'grain') $grain = intval($v);
		if ($k == 'method') $method = $v;
		if ($k == 'context') $context = intval($v);
	}
	
	$points = array();
	
	$nodelookup = array();	
	
	$points = $data[1]->value;
	
	if (count($points) > 0)
	{
		if ($points[0]->dynamic == "")
		{
			LiveValuesForPoints($points);
		}
	}
	
	
	
	$indx = -1;
	$finalpoints = array();
	$fixedpoints = array();
	//print_r($data[1]->value);
	foreach($points as $nd)
	{
		if ($nd->dynamic != "")
		{
			$indx++;
			$bits = explode(':',$nd->dynamic);
			$prp = array();
			$prp['property'] = $bits[1];
			$prp['node'] = $bits[2];
			$prp['asset'] = $bits[0];
			$prp['id'] = $indx;
						
			$finalpoints[] = $prp;
			
			$nodelookup[] = $nd;
		}
		else
		{
			$fixedpoints[] = $nd;
		}
	}
	
	/*if (count($finalpoints) == 0)
	{
		echo 'No Dynamic Elements!';
		$a = new AQLStackElement();
		$a->typename = "pointlist";
		$a->islist = true;
		$a->value = array();
		array_push($aql->stack,$a);
	}*/
	
	//date_default_timezone_set('UTC');
	
	//$ds = $datestart->format("Y-m-d h:i:s");
	//$de = $dateend->format("Y-m-d h:i:s");
	$ds = $datestart;
	$de = $dateend;	
		
	if (count($finalpoints) > 0)
	{
		$existingerrors = array();
		global $historyfailuremessages;
		foreach($historyfailuremessages as $hfm)
		{
			$existingerrors[] = $hfm;
		}
		
		$rows = GetBulkHistory($finalpoints,$ds,$de,$grain,$method,false,$context);	

		foreach($historyfailuremessages as $hfm)
		{
			$aql->errors .= $hfm."\n";
		}
		
		foreach($existingerrors as $hfm)
		{
			$historyfailuremessages[] = $hfm;
		}
		
		foreach($rows as $r)
		{
			//echo "Handing Row";
			if ($r[0] == "") $r[0] = 0;
			//print_r($r);
			if ($nodelookup[$r[0]]->history === FALSE)
			{
				$nodelookup[$r[0]]->history = array();
			}
			if ($timezone != "UTC")
			{
				$r[1] = GetHistoryStringToLocal($r[1],$timezone);
			}
			$nd = array($r[1],$r[2]);
			if (count($r) > 3)
			{
				for($x=3;$x<count($r);$x++)
				{
					$nd[1] .= ",".$r[$x];
				}
			}
			$nodelookup[$r[0]]->history[] = $nd;		
		}		
	}
		
	foreach($points as $pnt)
	{				
		if ($pnt->history === FALSE)
		{
			if ($pnt->rawvalue !== FALSE)
			{
				$pnt->history = array();
				$pnt->history[] = array($ds,$pnt->rawvalue);
				$pnt->history[] = array($de,$pnt->rawvalue);
			}
		}
	}
		
	unset($rows);
	
	$a = new AQLStackElement();
	$a->typename = "pointlist";
	$a->islist = true;
	$a->value = $points;
	array_push($aql->stack,$a);
	
	return;
}
