<?php
function fn_pointlookup_c($aql)
{
	$list = $aql->Consume(1);
	
	//Get the list of constants
	
	if (!is_array($list[0]->value))	
		$items = array($list[0]->value);	
	else
		$items = $list[0]->value;
	
	$ppool = array();
	
	$allprops = Properties::GetAllProperties();
	$plookup = array();
	$alookup = array();
	
	//For each of them, break into asset, property and node...
	foreach($items as $itm)
	{
		$bits = explode('.',$itm);
		if (count($bits) <= 1)
		{
			continue;
		}
		
		$assetname = $bits[0];
		$propertyname = $bits[1];
		$propertyid = FALSE;
		$assetid = FALSE;
		
		//Lookup Property ID from Name
		if (isset($plookup[$bits[1]]))
			$prop = $plookup[$bits[1]];
		else
		{
			foreach($allprops as $px)
			{
				if ($px->name == $propertyname)
				{
					$propertyid = $px->id;
					$plookup[$px->name] = $px->id;
					break;
				}
			}
		}
		
		//Lookup Asset ID from Name
		if (isset($alookup[$bits[0]]))
			$assetid = $alookup[$bits[0]];
		else
		{
			//Perform asset search
			$query = $db->query("SELECT name,id FROM assets WHERE name LIKE ".$db->quote('%'.$name.'%')." AND type=0".$extra);			
				
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				$assetid = $row['id'];
				if (strtolower($name) == strtolower($row['name']))
				{
					$assetid = $row['id'];
					break;
				}
				
				$alookup[$bits[0]] = $assetid;
			}			
		}
		
		
		if (($assetid !== FALSE) && ($propertyid !== FALSE))
		{
			$pnt = new AQLPoint();
			$pnt->assetid = $assetid;
			$pnt->sourceid = $assetid;
			$pnt->dynamic = "";
			$pnt->value = "";
			$pnt->propertyid = $propertyid;
			$pnt->processed = False;
			
			foreach($allprops as $px)
			{
				if ($px->id == $propertyid)
				{
					$pnt->type = $px->type;
					$pnt->name = $px->name;
				}
			}
			
			$ppool[] = $pnt;
		}
	}			
	
	//LiveValuesForPoints($ppool);
	
	$a = new AQLStackElement();
	$a->typename = "pointlist";
	$a->islist = true;
	$a->value = $ppool;
	array_push($aql->stack,$a);	
	
	return;
}
?>