<?php
function fn_refine_ap($aql)
{
	$list = $aql->Consume(2);
	
	//Find assets and properties that mix...
	print("Finding Assets With Properties...");
	
	global $db;
	global $assets;
	global $siteroot;
	$apool = array();
	
	$existing = array();
	foreach($list[1]->value as $n)
	{
		$existing[] = $n;
	}
	
	$propshortlist = array();
	foreach($list[0]->value as $n)
	{
		$propshortlist[] = $n;
	}
	
	//print_r($existing);
	
	$mt = microtime(true);
	
	global $debug;
	//if ($debug == true) echo '[ Getting Assets With Property';
	
	$extra = "";
	if (count($existing) > 0)
	{
		$extra = " AND (type=1 OR assetid IN (".implode(",",$existing)."))";
	}
	//Narrow search to assets with this property....
	$parentassets = array();
	$scanassets = array();
	
	$query = $db->query("SELECT assetid,propertyid,type,value FROM assetvalues JOIN assets ON (assets.id = assetvalues.assetid) WHERE propertyid IN (".implode(',',$propshortlist).")".$extra);	
	
	//echo "SELECT assetid,propertyid,type,value FROM assetvalues JOIN assets ON (assets.id = assetvalues.assetid) WHERE propertyid IN (".implode(',',$propshortlist).")".$extra;
	
	$values = array();
	$scanassetprops = array();
	
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		if ($row['type'] == 1)
		{
			$parentassets[] = $row['assetid'];
		}
		else
		{
			$scanassets[] = $row['assetid'];
		}
		if (!isset($scanassetprops[$row['assetid']]))
		{
			$scanassetprops[$row['assetid']] = array();			
		}
		$scanassetprops[$row['assetid']][] = $row['propertyid'];
		$values[$row['assetid']] = $row['value'];
	}
	
	$extra = "";
	if (count($existing) > 0)
	{
		$extra = " AND childasset IN (".implode(",",$existing).")";
	}
	
	if (count($parentassets) > 0)
	{
		foreach($parentassets as $par)
		{
			$query = $db->query("SELECT childasset FROM assetrelclosures JOIN assets ON (assets.id = assetrelclosures.childasset) WHERE parentasset=".$par." AND assets.type=0".$extra);
		
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				if (!in_array($row['childasset'],$scanassets))
				{
					$scanassets[] = $row['childasset'];
					$scanassetprops[$row['childasset']] = $scanassetprops[$par];
				}
				
				$values[$row['childasset']] = $values[$par];
			}
		}
	}
	
	sort($scanassets);
	$ahit = array();
	
	//print_r($scanassets);
	
	$plist = array();
	foreach($scanassets as $sca)
	{
		$asset = array();
		global $assetdata;
		$assetdata = array();
		
		$url = $siteroot.'/properties/'.$sca;
		
		$ass = new Asset($sca);
		if ($ass->tag == true) continue;
		$value = "";
		if (isset($values[$sca])) $value = $values[$sca];
		
		//Check for a monitors relationship....
		//print_r($asset[$sca]);
		$monitored = false;
		if (isset($asset[$sca]['relationships'][6]))
		{
			//echo 'Monitors Relationship Detected on '.$sca;
			//print_r($asset[$sca]['relationships'][6]);
			foreach($asset[$sca]['relationships'][6] as $r)
			{
				if ($r['upstream'] == true)
				{
					$other = new Asset($r['target']);
					$prp = $other->GetLocalProperties();
					$other->GetValues($prp,true,true);
					//print_r($prp);
					foreach($prp as $o)
					{
						if ($o->id == $propid)
						{
							//echo 'Ding!';
							$monitored = true;
							break;
						}
					}
				}
			}
		}
		
		if ($monitored == true)
		{
			continue;
		}
		
		$ahit[] = $sca;
				
		if (isset($values[$ass->id])) $value = $values[$ass->id];
		//$apool[] = $ass->id;				
		
		foreach($scanassetprops[$ass->id] as $sap)
		{
			$pnt = new AQLPoint();
			$pnt->assetid = $ass->id;
			$pnt->sourceid = $ass->id;
			$pnt->dynamic = "";
			$pnt->value = "";
			$pnt->propertyid = $sap;
			$apool[] = $pnt;
		}		
	}	
	
	$a = new AQLStackElement();
	$a->typename = "pointlist";
	$a->islist = true;
	$a->value = $apool;
	array_push($aql->stack,$a);
	
	//print_r($apool);
	return;
}

function fn_refine_pa($aql)
{
	$list = $aql->Consume(2);
	$aql->stack[] = $list[0];
	$aql->stack[] = $list[1];
	fn_resolve_ap($aql);
}

function fn_refine_aa($aql)
{
	$data = $aql->Consume(2);

	$lsta = $data[0]->value;
	$lstb = $data[1]->value;
	
	$final = $lsta;
	foreach($lstb as $b)
	{
		if (!in_array($b,$final))
		{
			$final[] = $b;
		}
	}
	
	$a = new AQLStackElement();
	$a->typename = "assetlist";
	$a->islist = true;
	$a->value = $final;
	array_push($aql->stack,$a);
}

?>