<?php
function fn_resolve_ap($aql)
{
	$list = $aql->Consume(2);
	
	//Find assets and properties that mix...
	//print("Finding Assets With Properties...");
	
	if (count($list[0]->value) == 0)
	{
		$a = new AQLStackElement();
		$a->typename = "pointlist";
		$a->islist = true;
		$a->value = array();
		array_push($aql->stack,$a);
		return;
	}
	
	if (count($list[1]->value) == 0)
	{
		$a = new AQLStackElement();
		$a->typename = "pointlist";
		$a->islist = true;
		$a->value = array();
		array_push($aql->stack,$a);
		return;
	}
	
	global $db;
	global $assets;
	global $siteroot;
	$apool = array();
	
	$existing = array();
	foreach($list[1]->value as $n)
	{
		$existing[] = $n;
	}
	
	$propshortlist = array();
	foreach($list[0]->value as $n)
	{
		$propshortlist[] = $n;
	}
	
	//print_r($existing);
	
	$mt = microtime(true);
	
	global $debug;
	//if ($debug == true) echo '[ Getting Assets With Property';
	
	$extra = "";
	if (count($existing) > 0)
	{
		$extra = " AND (type=1 OR assetid IN (".implode(",",$existing)."))";
	}
	
	//Narrow search to assets with this property....
	$parentassets = array();
	$scanassets = array();
	$query = $db->query("SELECT assetid,propertyid,type,value FROM assetvalues JOIN assets ON (assets.id = assetvalues.assetid) WHERE propertyid IN (".implode(',',$propshortlist).")".$extra);	
	
	//echo "SELECT assetid,propertyid,type,value FROM assetvalues JOIN assets ON (assets.id = assetvalues.assetid) WHERE propertyid IN (".implode(',',$propshortlist).")".$extra;
	
	$values = array();
	$scanassetprops = array();
	
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		if ($row['type'] == 1)
		{
			$parentassets[] = $row['assetid'];
		}
		else
		{
			if (!in_array($row['assetid'],$scanassets))
				$scanassets[] = $row['assetid'];
		}
		if (!isset($scanassetprops[$row['assetid']]))
		{
			$scanassetprops[$row['assetid']] = array();			
		}
		$scanassetprops[$row['assetid']][] = $row['propertyid'];
		if (!isset($values[$row['assetid']]))
		{
			$values[$row['assetid']] = array();
		}
		$values[$row['assetid']][$row['propertyid']] = $row['value'];
	}
	
	$extra = "";
	if (count($existing) > 0)
	{
		$extra = " AND childasset IN (".implode(",",$existing).")";
	}
	
	if (count($parentassets) > 0)
	{
		foreach($parentassets as $par)
		{
			$query = $db->query("SELECT childasset FROM assetrelclosures JOIN assets ON (assets.id = assetrelclosures.childasset) WHERE parentasset=".$par." AND assets.type=0".$extra);			
		
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{				
				if (!in_array($row['childasset'],$scanassets))
				{
					$scanassets[] = $row['childasset'];
					$scanassetprops[$row['childasset']] = $scanassetprops[$par];
				}
				
				if (isset($values[$par]))
				{		
					
					foreach($values[$par] as $k => $v)
					{
						if (!isset($values[$row['childasset']][$k]))
							$values[$row['childasset']][$k] = $v;
					}
				}
				else
				{
					echo 'Included In Scan - No Values?';
				}
			}
		}
	}
	
	//print_r($values);
	
	sort($scanassets);
	$ahit = array();
	
	$allprops = Properties::GetAllProperties();
	
	$plist = array();
	foreach($scanassets as $sca)
	{
		$asset = array();
		global $assetdata;
		$assetdata = array();
		
		$url = $siteroot.'/properties/'.$sca;
		
		$ass = new Asset($sca);
		if ($ass->tag == true) continue;
		$value = "";
		if (isset($values[$sca])) $value = $values[$sca];
		
		//Check for a monitors relationship....
		//print_r($asset[$sca]);
		$monitored = false;
		if (isset($asset[$sca]['relationships'][6]))
		{
			//echo 'Monitors Relationship Detected on '.$sca;
			//print_r($asset[$sca]['relationships'][6]);
			foreach($asset[$sca]['relationships'][6] as $r)
			{
				if ($r['upstream'] == true)
				{
					$other = new Asset($r['target']);
					$prp = $other->GetLocalProperties();
					$other->GetValues($prp,true,true);					
					foreach($prp as $o)
					{
						if ($o->id == $propid)
						{
							//echo 'Ding!';
							$monitored = true;
							break;
						}
					}
				}
			}
		}
		
		if ($monitored == true)
		{
			continue;
		}
		
		$ahit[] = $sca;
				
		//if (isset($values[$ass->id])) $value = $values[$ass->id];
		//$apool[] = $ass->id;				
		
		//foreach($scanassetprops[$ass->id] as $sap)
		foreach($value as $k => $v)
		{
			$pnt = new AQLPoint();
			$pnt->assetid = $ass->id;
			$pnt->sourceid = $ass->id;
			$pnt->dynamic = "";			
			$pnt->rawvalue = explode('|',$v)[0];
			$pnt->value = $pnt->rawvalue;
			$pnt->fullvalue = $v;
			$pnt->propertyid = $k;
			
			foreach($allprops as $pqq)
			{
				if ($pqq->id == $pnt->propertyid)
				{
					$pnt->type = $pqq->type;
					$pnt->name = $pqq->name;
					break;
				}
			}
			
			$pnt->processed = False;
			$apool[] = $pnt;
		}		
	}	
	
	$finalpoints = array();
	foreach($existing as $ex)
	{
		foreach($apool as $a)
		{
			if ($a->assetid == $ex)
			{
				$finalpoints[] = $a;
			}
		}
	}
	
	$a = new AQLStackElement();
	$a->typename = "pointlist";
	$a->islist = true;
	$a->value = $finalpoints;
	array_push($aql->stack,$a);
	
	//print_r($apool);
	return;
}

function fn_resolve_pa($aql)
{
	$list = $aql->Consume(2);
	$aql->stack[] = $list[0];
	$aql->stack[] = $list[1];
	fn_resolve_ap($aql);
}

function fn_resolve_aa($aql)
{
	$data = $aql->Consume(2);

	$lsta = $data[0]->value;
	$lstb = $data[1]->value;
	
	$final = $lsta;
	foreach($lstb as $b)
	{
		if (!in_array($b,$final))
		{
			$final[] = $b;
		}
	}
	
	$a = new AQLStackElement();
	$a->typename = "assetlist";
	$a->islist = true;
	$a->value = $final;
	array_push($aql->stack,$a);
}

?>