<?php
function aql_torate_ConvertToDate($dt)
{
	if (!is_numeric($dt))
		$dt = strtotime($dt);
	else
		$dt = intval($dt);
	return $dt;
}

function aql_torate_Calculate(&$itm,$res)
{
	if ($itm->history !== FALSE)
	{
		$base = FALSE;
		$lasttime = FALSE;
		$lastvalue = FALSE;
		$lastindex = -1;
		$lastrate = FALSE;
		$indx = -1;
		foreach($itm->history as $h)
		{				
			$indx += 1;
			$dt = aql_torate_ConvertToDate($h[0]);
			if ($base === FALSE)
			{
				$base = $dt;
				$lasttime = $dt;
				$lastvalue = $h[1];
				$lastindex = -1;
				continue;
			}
			if ($h[1] != $lastvalue)
			{
				if ($h[1] > $lastvalue)
				{
					$diff = $h[1] - $lastvalue;
					$dur = ($dt - $lasttime)/$res;
					$nv = $diff / $dur;					
					if ($lastrate === FALSE) $lastrate = $nv;
					
					//print("Increasing Point Value: ".$lastvalue.' to '.$h[1]." or ".$lastrate.' to '.$nv."<br/>");									
					
					for($q=$lastindex+1;$q<=$indx+1;$q++)
					{
						$pc = ($q - ($lastindex+1)) / ($indx-$lastindex);						
						$itm->history[$q][1] = ((1-$pc) * $lastrate) + ($pc * $nv);
						//print('&nbsp;&nbsp;Setting '.$q.' = '.$itm->history[$q][1].' ('.$pc.')<br/>');
					}
					
					$lasttime = $dt;
					$lastvalue = $h[1];
					$lastindex = $indx;
					$lastrate = $nv;
				}
				else
				{						
					//$itm->history[0][1] = $diff / $dur;
					$diff = $h[1];					
					$dur = ($dt - $lasttime)/$res;
					$nv = $diff / $dur;
					if ($nv == 0) $nv = $lastrate;
					if ($lastrate === FALSE) $lastrate = $nv;	

					//print("Dropping Point Value: ".$lastvalue.' to '.$h[1]." or ".$lastrate.' to '.$nv."<br/>");									
					
					for($q=$lastindex+1;$q<=$indx+1;$q++)
					{
						$pc = ($q - ($lastindex+1)) / ($indx-$lastindex);						
						$itm->history[$q][1] = ((1-$pc) * $lastrate) + ($pc * $nv);
						//print('&nbsp;&nbsp;Setting '.$q.' = '.$itm->history[$q][1].' ('.$pc.')<br/>');
					}
																
					$lastvalue = $h[1];
					if ($h[1] != 0)
					{
						$lasttime = $dt;
						$lastindex = $indx;
						$lastrate = $nv;
					}
				}
			}
			
		}		

		for($q=$lastindex+1;$q<count($itm->history);$q++)
		{			
			$itm->history[$q][1] = $lastrate;			
		}		
		//$itm->history[0][1] = $itm->history[1][1];
		unset($itm->history[count($itm->history)-1]);
	}
}

function fn_torate_t($aql)
{
	$list = $aql->Consume(1);
		
	$items = $list[0]->value;
		
	if ($list[0]->islist == false)
	{
		$items = array();
		$items[] = $list[0]->value;
	}
		
	foreach($items as $itm)
	{	
		aql_torate_Calculate($itm,1);
	}
	
	$a = new AQLStackElement();
	$a->typename = "pointlist";
	$a->islist = true;
	$a->value = $items;
	array_push($aql->stack,$a);
	
	//print_r($apool);
	return;
}

function fn_torate_tc($aql)
{
	$list = $aql->Consume(2);
	$span = $list[0]->value;		
	$items = $list[1]->value;	
		
	if ($list[1]->islist == false)
	{
		$items = array();
		$items[] = $list[1]->value;
	}
	
	if (is_array($span))
		$span = $span[0];
	
	$span = floatval($span);
	
	foreach($items as $itm)
	{	
		aql_torate_Calculate($itm,$span);
	}
	
	$a = new AQLStackElement();
	$a->typename = "pointlist";
	$a->islist = true;
	$a->value = $items;
	array_push($aql->stack,$a);
	
	//print_r($apool);
	return;
}

?>