<?php
function aql_total_ConvertToDate($dt)
{
	if (!is_numeric($dt))
		$dt = strtotime($dt);
	else
		$dt = intval($dt);
	return $dt;
}

function aql_total_Calculate(&$itm,$res)
{
	if ($itm->history !== FALSE)
	{
		$base = FALSE;
		$lasttime = FALSE;
		$lastvalue = FALSE;
		
		$indx = -1;
		$runningtotal = 0;
		$elapsedtime = 0;
		foreach($itm->history as $h)
		{							
			$dt = aql_total_ConvertToDate($h[0]);
			if ($base === FALSE)
			{
				$base = $dt;
				$lasttime = $dt;
				$lastvalue = $h[1];				
				continue;
			}
			$dur = ($dt - $lasttime);
			$runningtotal += ($lastvalue * $dur);
			$elapsedtime += $dur;
			
			//print("Adding ".$dur." Seconds @ " + str($runningtotal));
			
			$lasttime = $dt;			
			$lastvalue = $h[1];			
			
		}		
		
		$itm->history = FALSE;
		if ($res != 0)
		{
			//print("Setting ".$runningtotal." / ".$res);
			$itm->rawvalue = $runningtotal / $res;
			$itm->value = $runningtotal / $res;
		}
		else
			$itm->rawvalue = 0;
	}
}

function fn_total_t($aql)
{
	$list = $aql->Consume(1);
		
	$items = $list[0]->value;
		
	if ($list[0]->islist == false)
	{
		$items = array();
		$items[] = $list[0]->value;
	}
		
	foreach($items as $itm)
	{	
		aql_total_Calculate($itm,1);
	}
	
	$a = new AQLStackElement();
	$a->typename = "pointlist";
	$a->islist = true;
	$a->value = $items;
	array_push($aql->stack,$a);
	
	//print_r($apool);
	return;
}

function fn_total_tc($aql)
{
	$list = $aql->Consume(2);
	$span = $list[0]->value;		
	$items = $list[1]->value;	
		
	if ($list[1]->islist == false)
	{
		$items = array();
		$items[] = $list[1]->value;
	}
	
	if (is_array($span))
		$span = $span[0];
	
	$span = floatval($span);
	
	foreach($items as $itm)
	{	
		aql_total_Calculate($itm,$span);
	}
	
	$a = new AQLStackElement();
	$a->typename = "pointlist";
	$a->islist = true;
	$a->value = $items;
	array_push($aql->stack,$a);
	
	//print_r($apool);
	return;
}

?>